/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cb2xml;

import java.io.File;
import java.io.InputStream;
import net.sf.cb2xml.Cb2Xml2;
import net.sf.cb2xml.DebugParserException;
import net.sf.cb2xml.sablecc.parser.ParserException;
import net.sf.cb2xml.util.XmlUtils;
import org.w3c.dom.Document;

public class Cb2Xml {
    private static final int FIRST_COBOL_COLUMN = 6;
    private static final int LAST_COBOL_COLUMN = 72;

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Usage:\tcb2xml <copybookFileName> [debug]");
            return;
        }
        File file = new File(stringArray[0]);
        boolean bl = false;
        if (stringArray.length > 1) {
            bl = true;
        }
        String string = Cb2Xml.convertToXMLString(file, bl);
        System.out.println(string);
    }

    public static Document convertToXMLDOM(File file) {
        return Cb2Xml.convert(file, null, null, false);
    }

    public static String convertToXMLString(File file) {
        Document document = Cb2Xml.convert(file, null, null, false);
        return XmlUtils.domToString(document).toString();
    }

    public static Document convertToXMLDOM(File file, boolean bl) {
        return Cb2Xml.convert(file, null, null, bl);
    }

    public static Document convertToXMLDOM(File file, boolean bl, int n) {
        return Cb2Xml.convert(file, null, null, bl, n, 6, 72);
    }

    public static Document convertToXMLDOM(File file, boolean bl, int n, int n2) {
        return Cb2Xml.convert(file, null, null, bl, 2, n, n2);
    }

    public static Document convertToXMLDOM(InputStream inputStream, String string, boolean bl, int n) {
        return Cb2Xml.convert(null, inputStream, string, bl, n, 6, 72);
    }

    public static Document convertToXMLDOM(InputStream inputStream, String string, boolean bl, int n, int n2) {
        return Cb2Xml.convert(null, inputStream, string, bl, 2, n, n2);
    }

    public static String convertToXMLString(File file, boolean bl) {
        Document document = Cb2Xml.convert(file, null, null, bl);
        return XmlUtils.domToString(document).toString();
    }

    public static Document convertToXMLDOM(InputStream inputStream, String string) {
        return Cb2Xml.convert(null, inputStream, string, false);
    }

    public static String convertToXMLString(InputStream inputStream, String string) {
        Document document = Cb2Xml.convert(null, inputStream, string, false);
        return XmlUtils.domToString(document).toString();
    }

    public static Document convertToXMLDOM(InputStream inputStream, String string, boolean bl) {
        return Cb2Xml.convert(null, inputStream, string, bl);
    }

    public static String convertToXMLString(InputStream inputStream, String string, boolean bl) {
        Document document = Cb2Xml.convert(null, inputStream, string, bl);
        return XmlUtils.domToString(document).toString();
    }

    private static Document convert(File file, InputStream inputStream, String string, boolean bl) {
        return Cb2Xml.convert(file, inputStream, string, bl, 8, 6, 72);
    }

    public static Document convert(File file, InputStream inputStream, String string, boolean bl, int n, int n2, int n3) {
        Document document = null;
        try {
            document = Cb2Xml2.convert(file, inputStream, string, bl, n, n2, n3);
        }
        catch (DebugParserException debugParserException) {
            System.err.println("*** fatal parse error ***");
            System.err.println(debugParserException.getMessage());
            System.err.println("=== buffer dump start ===");
            System.err.println(debugParserException.buffer);
            System.err.println("=== buffer dump end ===");
        }
        catch (ParserException parserException) {
            System.err.println("*** fatal parse error ***");
            System.err.println(parserException.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return document;
    }
}

