/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.struct;

import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TableDefinition {
    private final List<ColumnDefinition> columnDefinitions = new ArrayList<ColumnDefinition>();
    private String tablespaceName;
    private String schema;
    private String name;
    private String creator;
    private String whenCondition;
    private Timestamp createdTimestamp = new Timestamp(0L);
    private Timestamp alteredTimestamp = new Timestamp(0L);
    private Map<String, Integer> columnMap;

    public TableDefinition() {
    }

    public TableDefinition(String schema, String name) {
        this.schema = schema;
        this.name = name;
    }

    public String getWhenCondition() {
        return this.whenCondition;
    }

    public void setWhenCondition(String whenCondition) {
        this.whenCondition = whenCondition;
    }

    public Timestamp getAlteredTimestamp() {
        return this.alteredTimestamp;
    }

    public void setAlteredTimestamp(Timestamp alteredTimestamp) {
        this.alteredTimestamp = alteredTimestamp;
    }

    public Timestamp getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public void setCreatedTimestamp(Timestamp createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public String getCreator() {
        return this.creator;
    }

    public void setCreator(String creator) {
        this.creator = creator;
    }

    public String getTablespaceName() {
        return this.tablespaceName;
    }

    public void setTablespaceName(String tablespaceName) {
        this.tablespaceName = tablespaceName;
    }

    public int hashCode() {
        int hash = 7;
        hash = 83 * hash + Objects.hashCode(this.schema);
        hash = 83 * hash + Objects.hashCode(this.name);
        hash = 83 * hash + Objects.hashCode(this.columnDefinitions);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TableDefinition other = (TableDefinition)obj;
        if (!Objects.equals(this.schema, other.schema)) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.columnDefinitions, other.columnDefinitions);
    }

    public int indexOfColumn(String columnName) {
        Integer no;
        if (this.columnMap == null) {
            this.columnMap = new HashMap<String, Integer>();
            int idx = 0;
            for (ColumnDefinition cd : this.columnDefinitions) {
                this.columnMap.put(cd.getName(), idx++);
            }
        }
        return (no = this.columnMap.get(columnName)) != null ? no : -1;
    }

    public ColumnDefinition getColumnDefinition(String columnName) {
        int index = this.indexOfColumn(columnName);
        return index != -1 ? this.columnDefinitions.get(index) : null;
    }

    public List<ColumnDefinition> getColumns() {
        return this.columnDefinitions;
    }

    public String getSchema() {
        return this.schema;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

