/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.index;

import java.util.Arrays;

public class ByteBuffer {
    private final byte[] buffer;
    private final byte[] markerBuffer;
    private byte[] finalBuffer;

    public ByteBuffer(int size) {
        this.buffer = new byte[size];
        this.markerBuffer = new byte[size];
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public byte[] getMarkerBuffer() {
        return this.markerBuffer;
    }

    private int fieldsFilledFromLeft() {
        int fieldsFilledFromLeft = -1;
        boolean zeroSeen = false;
        for (int i = 0; i < this.markerBuffer.length; ++i) {
            if (this.markerBuffer[i] == 0) {
                zeroSeen = true;
                continue;
            }
            fieldsFilledFromLeft = i;
            if (!zeroSeen) continue;
            return -1;
        }
        return fieldsFilledFromLeft;
    }

    public byte[] getFinalBuffer() {
        if (this.finalBuffer == null) {
            int fieldsFilledFromLeft = this.fieldsFilledFromLeft();
            if (fieldsFilledFromLeft == -1) {
                return null;
            }
            this.finalBuffer = Arrays.copyOf(this.buffer, fieldsFilledFromLeft + 1);
        }
        return this.finalBuffer;
    }
}

