/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.struct;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractItem;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.Item;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class Section
extends AbstractItem {
    private List<AbstractItem> fields = new ArrayList<AbstractItem>();

    public Section(Item parent, String name) {
        super(parent, name);
    }

    public void setFields(List<AbstractItem> fields) {
        this.fields = fields;
    }

    @Override
    public AbstractItem getItem(String name) {
        for (AbstractItem field : this.fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        return null;
    }

    public String printOffsets() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getName()).append(":\n");
        for (int i = 0; i < this.fields.size(); ++i) {
            sb.append(StringUtils.leftPad(String.valueOf(i), 5)).append(" ");
        }
        sb.append("\n");
        for (AbstractItem field : this.fields) {
            if (field.getMaximumOccurrences() > 1) {
                sb.append(StringUtils.leftPad("*", 5)).append(" ");
                continue;
            }
            sb.append(StringUtils.leftPad(String.valueOf(field.getPosition()), 5)).append(" ");
        }
        sb.append("\n");
        for (AbstractItem field : this.fields) {
            if (!(field instanceof Section)) continue;
            Section section = (Section)field;
            sb.append(section.printOffsets());
        }
        return sb.toString();
    }

    public Section createSection(String name) {
        return (Section)this.addItem(new Section(this, name));
    }

    public Field createField(String name, String typeName, int length) {
        return (Field)this.addItem(new Field(this, name, typeName, length, length, 0));
    }

    public Field createField(String name, String typeName, int length, int scale) {
        return (Field)this.addItem(new Field(this, name, typeName, length, length, scale));
    }

    public Set<String> getUsedTypes() {
        HashSet<String> typeSet = new HashSet<String>();
        for (AbstractItem item : this.fields) {
            if (item instanceof Field) {
                Field field = (Field)item;
                typeSet.add(field.getType());
                continue;
            }
            typeSet.addAll(((Section)item).getUsedTypes());
        }
        return typeSet;
    }

    public List<AbstractItem> getItems() {
        return this.fields;
    }

    @Override
    public boolean containsVaryingLengthElements() {
        if (this.getOccurrenceCounterField() != null) {
            return true;
        }
        for (AbstractItem a : this.fields) {
            if (!a.containsVaryingLengthElements()) continue;
            return true;
        }
        return false;
    }

    public AbstractItem addItem(AbstractItem f) {
        if (this.fields.isEmpty()) {
            f.setPosition(0);
        } else {
            AbstractItem lastField = this.fields.get(this.fields.size() - 1);
            int pos = lastField.getPosition();
            f.setPosition(pos == -1 ? 0 : pos + lastField.getLength());
        }
        this.fields.add(f);
        return f;
    }

    @Override
    public int getLength() {
        int fulllength = 0;
        for (AbstractItem f : this.fields) {
            fulllength += f.getLength();
        }
        return fulllength;
    }
}

