/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.index;

import de.ubs.jdbcserver.accessor.DataAccessor;
import de.ubs.jdbcserver.command.sql.ParameterValueData;
import de.ubs.jdbcserver.index.ByteBuffer;
import de.ubs.jdbcserver.index.IndexQueryByteBuilderVisitor;
import de.ubs.jdbcserver.index.IndexQueryDetectorVisitor;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TablespaceLayout;
import de.ubs.jdbcserver.jdbccomm.util.Pair;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import de.ubs.jdbcserver.splitter.SimpleRecordSplitter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class IndexUtils {
    private int keyOffset = 0;

    protected SQLParserParser.DisjunctionContext getWhereConditionFromStatement(StatementInformation statementInformation) {
        SQLParserParser.DisjunctionContext whereCondition = statementInformation.getWhereCondition();
        if (whereCondition == null && statementInformation.getStatementInformation().deleteStatement() != null && statementInformation.getStatementInformation().deleteStatement().whereClause() != null) {
            whereCondition = statementInformation.getStatementInformation().deleteStatement().whereClause().disjunction();
        }
        if (whereCondition == null && statementInformation.getStatementInformation().updateStatement() != null && statementInformation.getStatementInformation().updateStatement().whereClause() != null) {
            whereCondition = statementInformation.getStatementInformation().updateStatement().whereClause().disjunction();
        }
        return whereCondition;
    }

    public Boolean isIndexAccessPossible(TablespaceLayout layout, StatementInformation statementInformation) {
        try {
            SQLParserParser.DisjunctionContext whereCondition = this.getWhereConditionFromStatement(statementInformation);
            if (whereCondition != null) {
                Logger.getLogger(IndexUtils.class.getName()).log(Level.FINE, "Check condition: {0}", whereCondition.getText());
            }
            TableDefinition table = statementInformation.getTable();
            IndexQueryDetectorVisitor indexQueryDetectorOffset = new IndexQueryDetectorVisitor(table);
            return indexQueryDetectorOffset.visitDisjunction(whereCondition);
        }
        catch (SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public Pair<Boolean, List<ByteBuffer>> buildIndexPrefix(TablespaceLayout layout, StatementInformation statementInformation, ParameterValueData parameterMarkerContents) {
        try {
            SQLParserParser.DisjunctionContext whereCondition = this.getWhereConditionFromStatement(statementInformation);
            if (whereCondition != null) {
                Logger.getLogger(IndexUtils.class.getName()).log(Level.FINE, "Check condition: {0}", whereCondition.getText());
            }
            TableDefinition table = statementInformation.getTable();
            DataAccessor[] accessors = new SimpleRecordSplitter(layout, table).getDataAccessors();
            IndexQueryByteBuilderVisitor indexQueryDetectorOffset = new IndexQueryByteBuilderVisitor(statementInformation.getTable(), accessors, parameterMarkerContents);
            Object p = indexQueryDetectorOffset.visitDisjunction(whereCondition);
            this.keyOffset = indexQueryDetectorOffset.getKeyOffset();
            if (!((Boolean)((Pair)p).first()).booleanValue()) {
                return p;
            }
            for (ByteBuffer byteBuffer : (List)((Pair)p).second()) {
                if (byteBuffer.getFinalBuffer() != null) continue;
                return new Pair<Boolean, Object>(false, null);
            }
            return p;
        }
        catch (IOException | SQLException ex) {
            throw new RuntimeException(ex);
        }
    }

    public int getKeyOffset() {
        return this.keyOffset;
    }
}

