/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.accessor.mainframe;

import de.ubs.jdbcserver.accessor.AbstractDataAccessor;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;

public class StringAccessor
extends AbstractDataAccessor<String> {
    private final int length;
    private final Charset charset;
    private final CharsetEncoder encoder;
    private final CharBuffer charBuffer;
    private final char[] charArray;

    public StringAccessor(Field field, int position, Charset charset) {
        super(field, position);
        this.length = field.getLength();
        this.charset = charset;
        this.encoder = charset.newEncoder();
        this.charBuffer = CharBuffer.allocate(this.length);
        this.charArray = this.charBuffer.array();
    }

    @Override
    public String get(byte[] input, int offset) throws SQLException {
        return new String(input, this.position + offset, this.length, this.charset);
    }

    @Override
    public void put(String data, byte[] output, int offset) throws SQLException {
        if (data.length() < this.length) {
            data = StringUtils.rightPad(data, this.length);
        }
        try {
            data.getChars(0, this.length, this.charArray, 0);
            this.charBuffer.clear();
            this.charBuffer.limit(this.length);
            ByteBuffer byteBuffer = ByteBuffer.wrap(output, this.position + offset, this.length);
            this.encoder.encode(this.charBuffer, byteBuffer, true);
        }
        catch (RuntimeException e) {
            throw new SQLException(String.format("Character conversion cannot be performed because a string cannot be converted from %s to %s", Charset.forName("UTF-8").name(), this.charset.name()), "22021", -331);
        }
    }
}

