/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.struct;

import de.ubs.jdbcserver.jdbccomm.struct.ItemPath;
import java.util.Objects;

public class ColumnDefinition {
    private String name;
    private String label;
    private int type;
    private boolean nullable = true;
    private int length = 0;
    private int scale = 0;
    private ItemPath fieldPath;
    private String existenceExpression;
    private boolean readOnly = false;
    private int keySequence = -1;
    private String timestampPattern;

    public ColumnDefinition(String name) {
        this.name = name;
    }

    public ColumnDefinition(String name, int type, int length, int scale, boolean nullable, String[] referencedFieldPath) {
        this.name = name;
        this.fieldPath = new ItemPath(referencedFieldPath);
        this.type = type;
        this.length = length;
        this.scale = scale;
        this.nullable = nullable;
    }

    public ColumnDefinition(String name, String[] referencedFieldPath) {
        this.name = name;
        this.fieldPath = new ItemPath(referencedFieldPath);
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 1: {
                return "CHAR";
            }
            case -15: {
                return "NCHAR";
            }
            case 12: {
                return "VARCHAR";
            }
            case -9: {
                return "NVARCHAR";
            }
            case -16: {
                return "LONGNVARCHAR";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 3: {
                return "DECIMAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 4: {
                return "INTEGER";
            }
            case -5: {
                return "BIGINT";
            }
            case 6: 
            case 7: {
                return "FLOAT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 91: {
                return "DATE";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case 92: {
                return "TIME";
            }
            case -2: {
                return "BINARY";
            }
            case 2009: {
                return "XML";
            }
            case 16: {
                return "BOOLEAN";
            }
        }
        throw new RuntimeException("Unknown data type: " + type);
    }

    public String getTimestampPattern() {
        return this.timestampPattern;
    }

    public void setTimestampPattern(String timestampPattern) {
        this.timestampPattern = timestampPattern;
    }

    public int getKeySequence() {
        return this.keySequence;
    }

    public void setKeySequence(int keySequence) {
        this.keySequence = keySequence;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public String getExistenceExpression() {
        return this.existenceExpression;
    }

    public void setExistenceExpression(String existenceExpression) {
        this.existenceExpression = existenceExpression;
    }

    public int getScale() {
        return this.scale;
    }

    public void setScale(int scale) {
        this.scale = scale;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public ColumnDefinition deepCopy() {
        ColumnDefinition cd = new ColumnDefinition(this.name);
        cd.setLength(this.length);
        cd.setNullable(this.nullable);
        cd.setType(this.type);
        cd.setScale(this.scale);
        if (this.fieldPath != null) {
            cd.setFieldPath(new ItemPath(this.fieldPath.getPathElements()));
        }
        return cd;
    }

    public String getTypeName() {
        return ColumnDefinition.getTypeName(this.getType());
    }

    public void setTypeName(String typeName) {
        switch (typeName) {
            case "XML": {
                this.type = 2009;
                break;
            }
            case "CHAR": {
                this.type = 1;
                break;
            }
            case "NCHAR": {
                this.type = -15;
                break;
            }
            case "VARCHAR": {
                this.type = 12;
                break;
            }
            case "NVARCHAR": {
                this.type = -9;
                break;
            }
            case "LONGNVARCHAR": {
                this.type = -16;
                break;
            }
            case "LONGVARCHAR": {
                this.type = -1;
                break;
            }
            case "DECIMAL": {
                this.type = 3;
                break;
            }
            case "SMALLINT": {
                this.type = 5;
                break;
            }
            case "INTEGER": {
                this.type = 4;
                break;
            }
            case "BIGINT": {
                this.type = -5;
                break;
            }
            case "FLOAT": 
            case "REAL": {
                this.type = 6;
                break;
            }
            case "DOUBLE": {
                this.type = 8;
                break;
            }
            case "DATE": {
                this.type = 91;
                break;
            }
            case "TIMESTAMP": {
                this.type = 93;
                break;
            }
            case "TIME": {
                this.type = 92;
                break;
            }
            case "BINARY": {
                this.type = -2;
                break;
            }
            case "BOOLEAN": {
                this.type = 16;
                break;
            }
            default: {
                throw new RuntimeException("Unsupported data type conversion " + typeName);
            }
        }
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        switch (type) {
            case 7: {
                this.type = 6;
                break;
            }
            default: {
                this.type = type;
            }
        }
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public int getLength() {
        switch (this.type) {
            case 5: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case -5: {
                return 8;
            }
            case 91: {
                return 10;
            }
            case 92: {
                return 8;
            }
            case 93: {
                return this.scale == 0 ? 19 : 20 + this.scale;
            }
            case 8: {
                return 8;
            }
            case 6: 
            case 7: {
                return 4;
            }
        }
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public int hashCode() {
        int hash = 7;
        hash = 17 * hash + Objects.hashCode(this.name);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ColumnDefinition other = (ColumnDefinition)obj;
        return Objects.equals(this.name, other.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public ItemPath getFieldPath() {
        return this.fieldPath;
    }

    public void setFieldPath(ItemPath referencedFieldPath) {
        this.fieldPath = referencedFieldPath;
    }
}

