/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import de.ubs.jdbcserver.file.CsvFileReader;
import de.ubs.jdbcserver.file.UnixCsvFileReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class AbstractCsvFileReader
implements CsvFileReader {
    protected final CsvFileReader.HeaderProcessingMode headerProcessingMode;
    protected final CharsetDecoder charsetDecoder;
    protected boolean headerRead = false;
    protected char stringDelimiter = '\u0000';
    protected long recordNumber = 0L;

    public AbstractCsvFileReader(Charset encoding, CodingErrorAction codingErrorAction, char stringDelimiter, CsvFileReader.HeaderProcessingMode headerProcessingMode) {
        this.headerProcessingMode = headerProcessingMode;
        this.charsetDecoder = encoding.newDecoder();
        this.charsetDecoder.onMalformedInput(codingErrorAction);
        this.charsetDecoder.onUnmappableCharacter(codingErrorAction);
        this.stringDelimiter = stringDelimiter;
    }

    protected abstract String getNextRawRecord() throws IOException;

    @Override
    public final String readRecord() throws IOException {
        String r;
        Logger.getLogger(UnixCsvFileReader.class.getName()).log(Level.FINEST, String.format("AbstractCsvFileReader.readRecord() called", new Object[0]));
        do {
            if ((r = this.getNextRawRecord()) != null) continue;
            return null;
        } while (r.isEmpty());
        switch (this.headerProcessingMode) {
            case READ_AND_COUNT: {
                ++this.recordNumber;
                return r;
            }
            case READ_BUT_DO_NOT_COUNT: {
                if (!this.headerRead) {
                    this.headerRead = true;
                } else {
                    ++this.recordNumber;
                }
                return r;
            }
            case SKIP_AND_DO_NOT_COUNT: {
                if (!this.headerRead) {
                    this.headerRead = true;
                    return this.readRecord();
                }
                ++this.recordNumber;
                return r;
            }
        }
        throw new RuntimeException("Invalid header processing mode");
    }

    @Override
    public long getRecordNumber() {
        return this.recordNumber;
    }
}

