/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.command.sql;

import de.ubs.jdbcserver.command.sql.PreparedContext;
import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.jdbccomm.struct.ColumnDefinition;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import java.sql.SQLException;
import java.util.Optional;

public class PreparedInsertContext
extends PreparedContext {
    private final Object[] data;
    private final int[] indexes;
    private final SQLParserParser.InsertStatementContext insertCtx;

    public PreparedInsertContext(StatementInformation statementInformation) throws SQLException {
        this(statementInformation.getTable(), statementInformation.getStatementInformation().insertStatement());
    }

    private PreparedInsertContext(TableDefinition tableDefinition, SQLParserParser.InsertStatementContext insertCtx) throws SQLException {
        super(new ExpressionEvaluator<Object>(tableDefinition, null, null));
        this.insertCtx = insertCtx;
        this.data = new Object[tableDefinition.getColumns().size()];
        this.indexes = new int[insertCtx.sum().size()];
        if (!insertCtx.identifier().isEmpty()) {
            for (ColumnDefinition columnDefinition : tableDefinition.getColumns()) {
                Optional<SQLParserParser.IdentifierContext> columnInStatement;
                if (columnDefinition.isNullable() || (columnInStatement = insertCtx.identifier().stream().filter(ctx -> ctx.value.equals(columnDefinition.getName())).findFirst()).isPresent()) continue;
                throw new SQLException("Missing column " + columnDefinition.getName() + " in INSERT statement. Column is not nullable");
            }
        }
        if (!insertCtx.identifier().isEmpty()) {
            for (int i = 0; i < insertCtx.identifier().size(); ++i) {
                String columnName = insertCtx.identifier((int)i).value;
                this.indexes[i] = tableDefinition.indexOfColumn(columnName);
            }
        } else {
            for (int i = 0; i < insertCtx.sum().size(); ++i) {
                this.indexes[i] = i;
            }
        }
    }

    public SQLParserParser.InsertStatementContext getInsertCtx() {
        return this.insertCtx;
    }

    @Override
    public ExpressionEvaluator<Object> getVisitor() {
        return this.visitor;
    }

    public void setColumn(int idx, Object o) {
        this.data[this.indexes[idx]] = o;
    }

    public int getColumnCount() {
        return this.indexes.length;
    }

    public Object[] getData() {
        return this.data;
    }
}

