/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.TimeZone;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import org.apache.commons.lang3.time.FastDateFormat;

public class LogRecordFormatter
extends SimpleFormatter {
    private static FastDateFormat DATE_FORMATTER = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss");

    public static TimeZone getLogRecordTimeZone() {
        return DATE_FORMATTER.getTimeZone();
    }

    public static void setLogRecordTimeZone(TimeZone tz) {
        DATE_FORMATTER = FastDateFormat.getInstance("yyyy-MM-dd HH:mm:ss", tz);
    }

    @Override
    public String format(LogRecord record) {
        String threadName = Thread.currentThread().getName();
        String lr = String.format("%s %s %s %s%n", DATE_FORMATTER.format(new Date(record.getMillis())), record.getLevel().getName(), threadName, this.formatMessage(record));
        if (record.getThrown() != null) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            PrintStream ps = new PrintStream(byteArrayOutputStream);
            record.getThrown().printStackTrace(ps);
            lr = lr + new String(byteArrayOutputStream.toByteArray()) + "\n";
        }
        return lr;
    }
}

