/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cb2xml.sablecc.lexer;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.PushbackReader;
import net.sf.cb2xml.sablecc.lexer.LexerException;
import net.sf.cb2xml.sablecc.node.EOF;
import net.sf.cb2xml.sablecc.node.TAll;
import net.sf.cb2xml.sablecc.node.TAlphanumericLiteral;
import net.sf.cb2xml.sablecc.node.TAre;
import net.sf.cb2xml.sablecc.node.TAscending;
import net.sf.cb2xml.sablecc.node.TBinary;
import net.sf.cb2xml.sablecc.node.TBlank;
import net.sf.cb2xml.sablecc.node.TBy;
import net.sf.cb2xml.sablecc.node.TCharacter;
import net.sf.cb2xml.sablecc.node.TComma;
import net.sf.cb2xml.sablecc.node.TComment;
import net.sf.cb2xml.sablecc.node.TComp;
import net.sf.cb2xml.sablecc.node.TComp1;
import net.sf.cb2xml.sablecc.node.TComp2;
import net.sf.cb2xml.sablecc.node.TComp3;
import net.sf.cb2xml.sablecc.node.TComp4;
import net.sf.cb2xml.sablecc.node.TComp5;
import net.sf.cb2xml.sablecc.node.TComp6;
import net.sf.cb2xml.sablecc.node.TDataName;
import net.sf.cb2xml.sablecc.node.TDate;
import net.sf.cb2xml.sablecc.node.TDepending;
import net.sf.cb2xml.sablecc.node.TDescending;
import net.sf.cb2xml.sablecc.node.TDisplay;
import net.sf.cb2xml.sablecc.node.TDisplay1;
import net.sf.cb2xml.sablecc.node.TDollar;
import net.sf.cb2xml.sablecc.node.TDot;
import net.sf.cb2xml.sablecc.node.TDotMinus;
import net.sf.cb2xml.sablecc.node.TDotPlus;
import net.sf.cb2xml.sablecc.node.TDotZee;
import net.sf.cb2xml.sablecc.node.TExternal;
import net.sf.cb2xml.sablecc.node.TFiller;
import net.sf.cb2xml.sablecc.node.TFormat;
import net.sf.cb2xml.sablecc.node.TFunctionPointer;
import net.sf.cb2xml.sablecc.node.TGlobal;
import net.sf.cb2xml.sablecc.node.THighValues;
import net.sf.cb2xml.sablecc.node.TIndex;
import net.sf.cb2xml.sablecc.node.TIndexed;
import net.sf.cb2xml.sablecc.node.TIs;
import net.sf.cb2xml.sablecc.node.TJustified;
import net.sf.cb2xml.sablecc.node.TKey;
import net.sf.cb2xml.sablecc.node.TLeading;
import net.sf.cb2xml.sablecc.node.TLeft;
import net.sf.cb2xml.sablecc.node.TLowValues;
import net.sf.cb2xml.sablecc.node.TLparen;
import net.sf.cb2xml.sablecc.node.TMinus;
import net.sf.cb2xml.sablecc.node.TNational;
import net.sf.cb2xml.sablecc.node.TNative;
import net.sf.cb2xml.sablecc.node.TNulls;
import net.sf.cb2xml.sablecc.node.TNumber88;
import net.sf.cb2xml.sablecc.node.TNumberNot88;
import net.sf.cb2xml.sablecc.node.TNumericLiteral;
import net.sf.cb2xml.sablecc.node.TObject;
import net.sf.cb2xml.sablecc.node.TOccurs;
import net.sf.cb2xml.sablecc.node.TOn;
import net.sf.cb2xml.sablecc.node.TPackedDecimal;
import net.sf.cb2xml.sablecc.node.TPicture;
import net.sf.cb2xml.sablecc.node.TPlus;
import net.sf.cb2xml.sablecc.node.TPointer;
import net.sf.cb2xml.sablecc.node.TProcedurePointer;
import net.sf.cb2xml.sablecc.node.TQuotes;
import net.sf.cb2xml.sablecc.node.TRedefines;
import net.sf.cb2xml.sablecc.node.TReference;
import net.sf.cb2xml.sablecc.node.TRenames;
import net.sf.cb2xml.sablecc.node.TRight;
import net.sf.cb2xml.sablecc.node.TRparen;
import net.sf.cb2xml.sablecc.node.TSeparate;
import net.sf.cb2xml.sablecc.node.TSign;
import net.sf.cb2xml.sablecc.node.TSlash;
import net.sf.cb2xml.sablecc.node.TSpaces;
import net.sf.cb2xml.sablecc.node.TStar;
import net.sf.cb2xml.sablecc.node.TSynchronized;
import net.sf.cb2xml.sablecc.node.TThrough;
import net.sf.cb2xml.sablecc.node.TTimes;
import net.sf.cb2xml.sablecc.node.TTo;
import net.sf.cb2xml.sablecc.node.TTrailing;
import net.sf.cb2xml.sablecc.node.TUnknown;
import net.sf.cb2xml.sablecc.node.TUsage;
import net.sf.cb2xml.sablecc.node.TValue;
import net.sf.cb2xml.sablecc.node.TValues;
import net.sf.cb2xml.sablecc.node.TWhen;
import net.sf.cb2xml.sablecc.node.TWhiteSpace;
import net.sf.cb2xml.sablecc.node.TZeros;
import net.sf.cb2xml.sablecc.node.Token;

public class Lexer {
    protected Token token;
    protected State state = State.INITIAL;
    private PushbackReader in;
    private int line;
    private int pos;
    private boolean cr;
    private boolean eof;
    private final StringBuffer text = new StringBuffer();
    private static int[][][][] gotoTable;
    private static int[][] accept;

    protected void filter() throws LexerException, IOException {
    }

    public Lexer(PushbackReader pushbackReader) {
        this.in = pushbackReader;
        if (gotoTable == null) {
            try {
                int n;
                int n2;
                DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(Lexer.class.getResourceAsStream("lexer.dat")));
                int n3 = dataInputStream.readInt();
                gotoTable = new int[n3][][][];
                for (n2 = 0; n2 < gotoTable.length; ++n2) {
                    n3 = dataInputStream.readInt();
                    Lexer.gotoTable[n2] = new int[n3][][];
                    for (n = 0; n < gotoTable[n2].length; ++n) {
                        n3 = dataInputStream.readInt();
                        Lexer.gotoTable[n2][n] = new int[n3][3];
                        for (int i = 0; i < gotoTable[n2][n].length; ++i) {
                            for (int j = 0; j < 3; ++j) {
                                Lexer.gotoTable[n2][n][i][j] = dataInputStream.readInt();
                            }
                        }
                    }
                }
                n3 = dataInputStream.readInt();
                accept = new int[n3][];
                for (n2 = 0; n2 < accept.length; ++n2) {
                    n3 = dataInputStream.readInt();
                    Lexer.accept[n2] = new int[n3];
                    for (n = 0; n < accept[n2].length; ++n) {
                        Lexer.accept[n2][n] = dataInputStream.readInt();
                    }
                }
                dataInputStream.close();
            }
            catch (Exception exception) {
                throw new RuntimeException("The file \"lexer.dat\" is either missing or corrupted.");
            }
        }
    }

    public Token peek() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        return this.token;
    }

    public Token next() throws LexerException, IOException {
        while (this.token == null) {
            this.token = this.getToken();
            this.filter();
        }
        Token token = this.token;
        this.token = null;
        return token;
    }

    protected Token getToken() throws IOException, LexerException {
        int n = 0;
        int n2 = this.pos;
        int n3 = this.line;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int[][][] nArray = gotoTable[this.state.id()];
        int[] nArray2 = accept[this.state.id()];
        this.text.setLength(0);
        while (true) {
            int n9;
            if ((n9 = this.getChar()) != -1) {
                switch (n9) {
                    case 10: {
                        if (this.cr) {
                            this.cr = false;
                            break;
                        }
                        ++this.line;
                        this.pos = 0;
                        break;
                    }
                    case 13: {
                        ++this.line;
                        this.pos = 0;
                        this.cr = true;
                        break;
                    }
                    default: {
                        ++this.pos;
                        this.cr = false;
                    }
                }
                this.text.append((char)n9);
                block88: do {
                    int n10 = n < -1 ? -2 - n : n;
                    n = -1;
                    int[][] nArray3 = nArray[n10];
                    int n11 = 0;
                    int n12 = nArray3.length - 1;
                    while (n11 <= n12) {
                        int n13 = (n11 + n12) / 2;
                        int[] nArray4 = nArray3[n13];
                        if (n9 < nArray4[0]) {
                            n12 = n13 - 1;
                            continue;
                        }
                        if (n9 > nArray4[1]) {
                            n11 = n13 + 1;
                            continue;
                        }
                        n = nArray4[2];
                        continue block88;
                    }
                } while (n < -1);
            } else {
                n = -1;
            }
            if (n >= 0) {
                if (nArray2[n] == -1) continue;
                n4 = n;
                n5 = nArray2[n];
                n6 = this.text.length();
                n7 = this.pos;
                n8 = this.line;
                continue;
            }
            if (n4 == -1) break;
            switch (n5) {
                case 0: {
                    Token token = this.new0(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 1: {
                    Token token = this.new1(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 2: {
                    Token token = this.new2(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 3: {
                    Token token = this.new3(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 4: {
                    Token token = this.new4(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 5: {
                    Token token = this.new5(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 6: {
                    Token token = this.new6(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 7: {
                    Token token = this.new7(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 8: {
                    Token token = this.new8(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 9: {
                    Token token = this.new9(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 10: {
                    Token token = this.new10(n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 11: {
                    Token token = this.new11(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 12: {
                    Token token = this.new12(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 13: {
                    Token token = this.new13(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 14: {
                    Token token = this.new14(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 15: {
                    Token token = this.new15(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 16: {
                    Token token = this.new16(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 17: {
                    Token token = this.new17(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 18: {
                    Token token = this.new18(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 19: {
                    Token token = this.new19(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 20: {
                    Token token = this.new20(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 21: {
                    Token token = this.new21(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 22: {
                    Token token = this.new22(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 23: {
                    Token token = this.new23(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 24: {
                    Token token = this.new24(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 25: {
                    Token token = this.new25(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 26: {
                    Token token = this.new26(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 27: {
                    Token token = this.new27(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 28: {
                    Token token = this.new28(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 29: {
                    Token token = this.new29(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 30: {
                    Token token = this.new30(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 31: {
                    Token token = this.new31(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 32: {
                    Token token = this.new32(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 33: {
                    Token token = this.new33(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 34: {
                    Token token = this.new34(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 35: {
                    Token token = this.new35(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 36: {
                    Token token = this.new36(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 37: {
                    Token token = this.new37(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 38: {
                    Token token = this.new38(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 39: {
                    Token token = this.new39(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 40: {
                    Token token = this.new40(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 41: {
                    Token token = this.new41(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 42: {
                    Token token = this.new42(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 43: {
                    Token token = this.new43(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 44: {
                    Token token = this.new44(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 45: {
                    Token token = this.new45(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 46: {
                    Token token = this.new46(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 47: {
                    Token token = this.new47(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 48: {
                    Token token = this.new48(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 49: {
                    Token token = this.new49(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 50: {
                    Token token = this.new50(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 51: {
                    Token token = this.new51(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 52: {
                    Token token = this.new52(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 53: {
                    Token token = this.new53(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 54: {
                    Token token = this.new54(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 55: {
                    Token token = this.new55(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 56: {
                    Token token = this.new56(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 57: {
                    Token token = this.new57(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 58: {
                    Token token = this.new58(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 59: {
                    Token token = this.new59(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 60: {
                    Token token = this.new60(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 61: {
                    Token token = this.new61(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 62: {
                    Token token = this.new62(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 63: {
                    Token token = this.new63(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 64: {
                    Token token = this.new64(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 65: {
                    Token token = this.new65(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 66: {
                    Token token = this.new66(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 67: {
                    Token token = this.new67(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 68: {
                    Token token = this.new68(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 69: {
                    Token token = this.new69(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 70: {
                    Token token = this.new70(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 71: {
                    Token token = this.new71(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 72: {
                    Token token = this.new72(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 73: {
                    Token token = this.new73(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 74: {
                    Token token = this.new74(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 75: {
                    Token token = this.new75(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 76: {
                    Token token = this.new76(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 77: {
                    Token token = this.new77(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 78: {
                    Token token = this.new78(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 79: {
                    Token token = this.new79(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
                case 80: {
                    Token token = this.new80(this.getText(n6), n3 + 1, n2 + 1);
                    this.pushBack(n6);
                    this.pos = n7;
                    this.line = n8;
                    return token;
                }
            }
        }
        if (this.text.length() > 0) {
            throw new LexerException("[" + (n3 + 1) + "," + (n2 + 1) + "]" + " Unknown token: " + this.text);
        }
        EOF eOF = new EOF(n3 + 1, n2 + 1);
        return eOF;
    }

    Token new0(String string, int n, int n2) {
        return new TWhiteSpace(string, n, n2);
    }

    Token new1(String string, int n, int n2) {
        return new TComment(string, n, n2);
    }

    Token new2(int n, int n2) {
        return new TDot(n, n2);
    }

    Token new3(int n, int n2) {
        return new TComma(n, n2);
    }

    Token new4(int n, int n2) {
        return new TSlash(n, n2);
    }

    Token new5(int n, int n2) {
        return new TPlus(n, n2);
    }

    Token new6(int n, int n2) {
        return new TMinus(n, n2);
    }

    Token new7(int n, int n2) {
        return new TStar(n, n2);
    }

    Token new8(int n, int n2) {
        return new TDollar(n, n2);
    }

    Token new9(int n, int n2) {
        return new TLparen(n, n2);
    }

    Token new10(int n, int n2) {
        return new TRparen(n, n2);
    }

    Token new11(String string, int n, int n2) {
        return new TNumber88(string, n, n2);
    }

    Token new12(String string, int n, int n2) {
        return new TNumberNot88(string, n, n2);
    }

    Token new13(String string, int n, int n2) {
        return new TAlphanumericLiteral(string, n, n2);
    }

    Token new14(String string, int n, int n2) {
        return new TNumericLiteral(string, n, n2);
    }

    Token new15(String string, int n, int n2) {
        return new TDotZee(string, n, n2);
    }

    Token new16(String string, int n, int n2) {
        return new TDotMinus(string, n, n2);
    }

    Token new17(String string, int n, int n2) {
        return new TDotPlus(string, n, n2);
    }

    Token new18(String string, int n, int n2) {
        return new TAll(string, n, n2);
    }

    Token new19(String string, int n, int n2) {
        return new TAre(string, n, n2);
    }

    Token new20(String string, int n, int n2) {
        return new TAscending(string, n, n2);
    }

    Token new21(String string, int n, int n2) {
        return new TBinary(string, n, n2);
    }

    Token new22(String string, int n, int n2) {
        return new TBlank(string, n, n2);
    }

    Token new23(String string, int n, int n2) {
        return new TBy(string, n, n2);
    }

    Token new24(String string, int n, int n2) {
        return new TCharacter(string, n, n2);
    }

    Token new25(String string, int n, int n2) {
        return new TComp(string, n, n2);
    }

    Token new26(String string, int n, int n2) {
        return new TComp1(string, n, n2);
    }

    Token new27(String string, int n, int n2) {
        return new TComp2(string, n, n2);
    }

    Token new28(String string, int n, int n2) {
        return new TComp3(string, n, n2);
    }

    Token new29(String string, int n, int n2) {
        return new TComp4(string, n, n2);
    }

    Token new30(String string, int n, int n2) {
        return new TComp5(string, n, n2);
    }

    Token new31(String string, int n, int n2) {
        return new TComp6(string, n, n2);
    }

    Token new32(String string, int n, int n2) {
        return new TDate(string, n, n2);
    }

    Token new33(String string, int n, int n2) {
        return new TDepending(string, n, n2);
    }

    Token new34(String string, int n, int n2) {
        return new TDescending(string, n, n2);
    }

    Token new35(String string, int n, int n2) {
        return new TDisplay(string, n, n2);
    }

    Token new36(String string, int n, int n2) {
        return new TDisplay1(string, n, n2);
    }

    Token new37(String string, int n, int n2) {
        return new TExternal(string, n, n2);
    }

    Token new38(String string, int n, int n2) {
        return new TFiller(string, n, n2);
    }

    Token new39(String string, int n, int n2) {
        return new TFormat(string, n, n2);
    }

    Token new40(String string, int n, int n2) {
        return new TFunctionPointer(string, n, n2);
    }

    Token new41(String string, int n, int n2) {
        return new TGlobal(string, n, n2);
    }

    Token new42(String string, int n, int n2) {
        return new THighValues(string, n, n2);
    }

    Token new43(String string, int n, int n2) {
        return new TIndex(string, n, n2);
    }

    Token new44(String string, int n, int n2) {
        return new TIndexed(string, n, n2);
    }

    Token new45(String string, int n, int n2) {
        return new TIs(string, n, n2);
    }

    Token new46(String string, int n, int n2) {
        return new TJustified(string, n, n2);
    }

    Token new47(String string, int n, int n2) {
        return new TKey(string, n, n2);
    }

    Token new48(String string, int n, int n2) {
        return new TLeading(string, n, n2);
    }

    Token new49(String string, int n, int n2) {
        return new TLeft(string, n, n2);
    }

    Token new50(String string, int n, int n2) {
        return new TLowValues(string, n, n2);
    }

    Token new51(String string, int n, int n2) {
        return new TNational(string, n, n2);
    }

    Token new52(String string, int n, int n2) {
        return new TNative(string, n, n2);
    }

    Token new53(String string, int n, int n2) {
        return new TNulls(string, n, n2);
    }

    Token new54(String string, int n, int n2) {
        return new TObject(string, n, n2);
    }

    Token new55(String string, int n, int n2) {
        return new TOccurs(string, n, n2);
    }

    Token new56(String string, int n, int n2) {
        return new TOn(string, n, n2);
    }

    Token new57(String string, int n, int n2) {
        return new TPackedDecimal(string, n, n2);
    }

    Token new58(String string, int n, int n2) {
        return new TPicture(string, n, n2);
    }

    Token new59(String string, int n, int n2) {
        return new TPointer(string, n, n2);
    }

    Token new60(String string, int n, int n2) {
        return new TProcedurePointer(string, n, n2);
    }

    Token new61(String string, int n, int n2) {
        return new TQuotes(string, n, n2);
    }

    Token new62(String string, int n, int n2) {
        return new TRedefines(string, n, n2);
    }

    Token new63(String string, int n, int n2) {
        return new TReference(string, n, n2);
    }

    Token new64(String string, int n, int n2) {
        return new TRenames(string, n, n2);
    }

    Token new65(String string, int n, int n2) {
        return new TRight(string, n, n2);
    }

    Token new66(String string, int n, int n2) {
        return new TSeparate(string, n, n2);
    }

    Token new67(String string, int n, int n2) {
        return new TSign(string, n, n2);
    }

    Token new68(String string, int n, int n2) {
        return new TSpaces(string, n, n2);
    }

    Token new69(String string, int n, int n2) {
        return new TSynchronized(string, n, n2);
    }

    Token new70(String string, int n, int n2) {
        return new TThrough(string, n, n2);
    }

    Token new71(String string, int n, int n2) {
        return new TTimes(string, n, n2);
    }

    Token new72(String string, int n, int n2) {
        return new TTo(string, n, n2);
    }

    Token new73(String string, int n, int n2) {
        return new TTrailing(string, n, n2);
    }

    Token new74(String string, int n, int n2) {
        return new TUsage(string, n, n2);
    }

    Token new75(String string, int n, int n2) {
        return new TValue(string, n, n2);
    }

    Token new76(String string, int n, int n2) {
        return new TValues(string, n, n2);
    }

    Token new77(String string, int n, int n2) {
        return new TWhen(string, n, n2);
    }

    Token new78(String string, int n, int n2) {
        return new TZeros(string, n, n2);
    }

    Token new79(String string, int n, int n2) {
        return new TDataName(string, n, n2);
    }

    Token new80(String string, int n, int n2) {
        return new TUnknown(string, n, n2);
    }

    private int getChar() throws IOException {
        if (this.eof) {
            return -1;
        }
        int n = this.in.read();
        if (n == -1) {
            this.eof = true;
        }
        return n;
    }

    private void pushBack(int n) throws IOException {
        int n2 = this.text.length();
        for (int i = n2 - 1; i >= n; --i) {
            this.eof = false;
            this.in.unread(this.text.charAt(i));
        }
    }

    protected void unread(Token token) throws IOException {
        String string = token.getText();
        int n = string.length();
        for (int i = n - 1; i >= 0; --i) {
            this.eof = false;
            this.in.unread(string.charAt(i));
        }
        this.pos = token.getPos() - 1;
        this.line = token.getLine() - 1;
    }

    private String getText(int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.text.charAt(i));
        }
        return stringBuffer.toString();
    }

    public static class State {
        public static final State INITIAL = new State(0);
        private int id;

        private State(int n) {
            this.id = n;
        }

        public int id() {
            return this.id;
        }
    }
}

