/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cb2xml;

import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.cb2xml.def.DialectManager;
import net.sf.cb2xml.def.NumericDefinition;
import net.sf.cb2xml.sablecc.analysis.DepthFirstAdapter;
import net.sf.cb2xml.sablecc.node.ABinaryUsagePhrase;
import net.sf.cb2xml.sablecc.node.ABlankWhenZeroClause;
import net.sf.cb2xml.sablecc.node.ABlankWhenZeroClauseClause;
import net.sf.cb2xml.sablecc.node.AComp1UsagePhrase;
import net.sf.cb2xml.sablecc.node.AComp2UsagePhrase;
import net.sf.cb2xml.sablecc.node.AComp3UsagePhrase;
import net.sf.cb2xml.sablecc.node.AComp4UsagePhrase;
import net.sf.cb2xml.sablecc.node.AComp5UsagePhrase;
import net.sf.cb2xml.sablecc.node.AComp6UsagePhrase;
import net.sf.cb2xml.sablecc.node.ACompUsagePhrase;
import net.sf.cb2xml.sablecc.node.ADisplay1UsagePhrase;
import net.sf.cb2xml.sablecc.node.ADisplayUsagePhrase;
import net.sf.cb2xml.sablecc.node.AFixedOccursFixedOrVariable;
import net.sf.cb2xml.sablecc.node.AFunctionPointerUsagePhrase;
import net.sf.cb2xml.sablecc.node.AIndexUsagePhrase;
import net.sf.cb2xml.sablecc.node.AItem;
import net.sf.cb2xml.sablecc.node.ALeadingLeadingOrTrailing;
import net.sf.cb2xml.sablecc.node.ANationalUsagePhrase;
import net.sf.cb2xml.sablecc.node.AObjectReferencePhrase;
import net.sf.cb2xml.sablecc.node.AOccursTo;
import net.sf.cb2xml.sablecc.node.APackedDecimalUsagePhrase;
import net.sf.cb2xml.sablecc.node.APictureClause;
import net.sf.cb2xml.sablecc.node.APointerUsagePhrase;
import net.sf.cb2xml.sablecc.node.AProcedurePointerUsagePhrase;
import net.sf.cb2xml.sablecc.node.ARecordDescription;
import net.sf.cb2xml.sablecc.node.ARedefinesClause;
import net.sf.cb2xml.sablecc.node.ASequenceLiteralSequence;
import net.sf.cb2xml.sablecc.node.ASignClause;
import net.sf.cb2xml.sablecc.node.ASingleLiteralSequence;
import net.sf.cb2xml.sablecc.node.ASynchronizedClauseClause;
import net.sf.cb2xml.sablecc.node.AThroughSequenceLiteralSequence;
import net.sf.cb2xml.sablecc.node.AThroughSingleLiteralSequence;
import net.sf.cb2xml.sablecc.node.ATrailingLeadingOrTrailing;
import net.sf.cb2xml.sablecc.node.AValueClause;
import net.sf.cb2xml.sablecc.node.AValueItem;
import net.sf.cb2xml.sablecc.node.AVariableOccursFixedOrVariable;
import net.sf.cb2xml.sablecc.node.PDataNameOrFiller;
import net.sf.cb2xml.sablecc.node.TAlphanumericLiteral;
import net.sf.cb2xml.sablecc.node.THighValues;
import net.sf.cb2xml.sablecc.node.TLowValues;
import net.sf.cb2xml.sablecc.node.TNulls;
import net.sf.cb2xml.sablecc.node.TNumber88;
import net.sf.cb2xml.sablecc.node.TNumberNot88;
import net.sf.cb2xml.sablecc.node.TQuotes;
import net.sf.cb2xml.sablecc.node.TSpaces;
import net.sf.cb2xml.sablecc.node.TZeros;
import net.sf.cb2xml.sablecc.node.Token;
import net.sf.cb2xml.sablecc.parser.Parser;
import net.sf.cb2xml.util.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CopyBookAnalyzer
extends DepthFirstAdapter {
    private static NumericDefinition defaultNumDef = DialectManager.MAINFRAME_NUMERIC_DEFINITION;
    private final NumericDefinition numDef;
    private final Parser parser;
    private String copyBookName;
    private Document document;
    private Item prevItem;
    private Item curItem;

    public CopyBookAnalyzer(String string, Parser parser) {
        this(string, parser, defaultNumDef);
    }

    public CopyBookAnalyzer(String string, Parser parser, NumericDefinition numericDefinition) {
        this.copyBookName = string;
        this.parser = parser;
        this.numDef = numericDefinition;
    }

    public Document getDocument() {
        return this.document;
    }

    public void inARecordDescription(ARecordDescription aRecordDescription) {
        this.document = XmlUtils.getNewXmlDocument();
        Element element = this.document.createElement("copybook");
        element.setAttribute("filename", this.copyBookName);
        this.document.appendChild(element);
    }

    public void outARecordDescription(ARecordDescription aRecordDescription) {
        int n = 1;
        NodeList nodeList = this.document.getDocumentElement().getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            Element element = (Element)nodeList.item(i);
            if ("01".equals(element.getAttribute("level"))) {
                this.postProcessNode(element, 1);
                continue;
            }
            n = this.postProcessNode(element, n);
        }
    }

    public void caseTNumberNot88(TNumberNot88 tNumberNot88) {
        this.checkForComments(tNumberNot88);
    }

    public void caseTNumber88(TNumber88 tNumber88) {
        this.checkForComments(tNumber88);
    }

    public void checkForComments(Token token) {
        List list = (List)this.parser.ignoredTokens.getIn(token);
        if (list != null) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String string = iterator.next().toString().trim();
                if (string.length() <= 1) continue;
                this.curItem.element.getParentNode().insertBefore(this.document.createComment(this.correctForMinus(string)), this.curItem.element);
            }
        }
    }

    private String correctForMinus(String string) {
        int n = string.indexOf("--");
        if (n >= 0) {
            StringBuffer stringBuffer = new StringBuffer(string);
            for (int i = n; i < string.length() && stringBuffer.charAt(i) == '-'; ++i) {
                stringBuffer.replace(i, i + 1, "=");
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public void inAItem(AItem aItem) {
        int n = Integer.parseInt(aItem.getNumberNot88().toString().trim());
        PDataNameOrFiller pDataNameOrFiller = aItem.getDataNameOrFiller();
        String string = "";
        if (pDataNameOrFiller != null) {
            string = pDataNameOrFiller.toString().trim();
        }
        this.curItem = new Item(n, string);
        if (n <= 77) {
            block12: {
                if (this.prevItem == null) {
                    this.document.getDocumentElement().appendChild(this.curItem.element);
                } else if (this.curItem.level > this.prevItem.level) {
                    this.prevItem.element.appendChild(this.curItem.element);
                } else if (this.curItem.level == this.prevItem.level) {
                    this.prevItem.element.getParentNode().appendChild(this.curItem.element);
                } else if (this.curItem.level < this.prevItem.level) {
                    int n2;
                    Element element = this.prevItem.element;
                    do {
                        String string2;
                        if ("".equals(string2 = (element = (Element)element.getParentNode()).getAttribute("level"))) {
                            element.appendChild(this.curItem.element);
                        } else {
                            n2 = Integer.parseInt(string2);
                            if (n2 != this.curItem.level) continue;
                            element.getParentNode().appendChild(this.curItem.element);
                        }
                        break block12;
                    } while (n2 >= this.curItem.level);
                    element.appendChild(this.curItem.element);
                }
            }
            this.prevItem = this.curItem;
        }
    }

    public void inARedefinesClause(ARedefinesClause aRedefinesClause) {
        String string = aRedefinesClause.getDataName().getText();
        this.curItem.element.setAttribute("redefines", string);
    }

    public void inAFixedOccursFixedOrVariable(AFixedOccursFixedOrVariable aFixedOccursFixedOrVariable) {
        this.curItem.element.setAttribute("occurs", aFixedOccursFixedOrVariable.getNumber().toString().trim());
    }

    public void inAVariableOccursFixedOrVariable(AVariableOccursFixedOrVariable aVariableOccursFixedOrVariable) {
        this.curItem.element.setAttribute("occurs", aVariableOccursFixedOrVariable.getNumber().toString().trim());
        this.curItem.element.setAttribute("depending-on", aVariableOccursFixedOrVariable.getDataName().getText());
    }

    public void inAOccursTo(AOccursTo aOccursTo) {
        this.curItem.element.setAttribute("occurs-min", aOccursTo.getNumber().toString().trim());
    }

    public void inASynchronizedClauseClause(ASynchronizedClauseClause aSynchronizedClauseClause) {
        this.curItem.element.setAttribute("sync", "true");
    }

    /*
     * Unable to fully structure code
     */
    public void inAPictureClause(APictureClause var1_1) {
        var2_2 = true;
        var3_3 = this.removeChars(var1_1.getCharacterString().toString(), " ");
        this.curItem.element.setAttribute("picture", var3_3);
        if (var3_3.charAt(0) == 'S' || var3_3.charAt(0) == 's') {
            this.curItem.element.setAttribute("signed", "true");
            var3_3 = var3_3.substring(1);
            var2_2 = false;
        }
        var4_4 = 0;
        var5_5 = 0;
        var6_6 = 0;
        var7_7 = 0;
        if (this.curItem.element.hasAttribute("display-length")) {
            var4_4 = Integer.parseInt(this.curItem.element.getAttribute("display-length"));
        }
        if (this.curItem.element.hasAttribute("storage-length")) {
            var7_7 = Integer.parseInt(this.curItem.element.getAttribute("storage-length"));
        }
        var8_8 = -1;
        var9_9 = false;
        var10_10 = true;
        var11_11 = var3_3.toUpperCase();
        block12: for (var12_12 = 0; var12_12 < var3_3.length(); ++var12_12) {
            var13_13 = var11_11.charAt(var12_12);
            switch (var13_13) {
                case 'A': 
                case 'B': 
                case 'E': {
                    ++var7_7;
                }
                case 'G': 
                case 'N': {
                    ++var7_7;
                    ++var4_4;
                    continue block12;
                }
                ** case 46:
lbl30:
                // 2 sources

                case 'V': {
                    var9_9 = true;
                    var8_8 = ++var4_4;
                    continue block12;
                }
                case 'P': {
                    var9_9 = true;
                    ++var4_4;
                    if (var8_8 < 0) {
                        ++var5_5;
                        continue block12;
                    }
                    ++var6_6;
                    continue block12;
                }
                case '$': {
                    if (var10_10) {
                        var10_10 = false;
                        var9_9 = true;
                        continue block12;
                    }
                    ++var4_4;
                    continue block12;
                }
                case 'C': 
                case 'D': {
                    ++var12_12;
                }
                case '*': 
                case '+': 
                case '-': 
                case '0': 
                case '9': 
                case 'Z': {
                    var9_9 = true;
                }
                case ',': 
                case '/': 
                case 'X': {
                    ++var4_4;
                    continue block12;
                }
                case '(': {
                    var14_14 = var3_3.indexOf(41, var12_12 + 1);
                    var15_15 = Integer.parseInt(var3_3.substring(var12_12 + 1, var14_14));
                    var12_12 = var14_14;
                    var4_4 = var4_4 + var15_15 - 1;
                }
            }
        }
        this.setLength(this.curItem.element, var2_2, var4_4, var5_5 + var6_6);
        if (var8_8 != -1 && var4_4 - var8_8 != var6_6) {
            this.curItem.element.setAttribute("scale", var4_4 - var8_8 + "");
            if (var3_3.indexOf(46) != -1) {
                this.curItem.element.setAttribute("insert-decimal-point", "true");
            }
        } else if (var5_5 > 0) {
            this.curItem.element.setAttribute("scale", "-" + var5_5);
        }
        if (var9_9) {
            this.curItem.element.setAttribute("numeric", "true");
        }
    }

    public void inASignClause(ASignClause aSignClause) {
        if (aSignClause.getSeparateCharacter() != null) {
            this.curItem.element.setAttribute("sign-separate", "true");
        }
    }

    public void inALeadingLeadingOrTrailing(ALeadingLeadingOrTrailing aLeadingLeadingOrTrailing) {
        this.curItem.element.setAttribute("sign-position", "leading");
    }

    public void inATrailingLeadingOrTrailing(ATrailingLeadingOrTrailing aTrailingLeadingOrTrailing) {
        this.curItem.element.setAttribute("sign-position", "trailing");
    }

    public void inABlankWhenZeroClause(ABlankWhenZeroClause aBlankWhenZeroClause) {
        this.curItem.element.setAttribute("blank-when-zero", "true");
        super.inABlankWhenZeroClause(aBlankWhenZeroClause);
    }

    public void inABlankWhenZeroClauseClause(ABlankWhenZeroClauseClause aBlankWhenZeroClauseClause) {
        this.curItem.element.setAttribute("blank-when-zero", "true");
        super.inABlankWhenZeroClauseClause(aBlankWhenZeroClauseClause);
    }

    public void inABinaryUsagePhrase(ABinaryUsagePhrase aBinaryUsagePhrase) {
        this.curItem.element.setAttribute("usage", "binary");
        this.curItem.element.setAttribute("numeric", "true");
    }

    public void inACompUsagePhrase(ACompUsagePhrase aCompUsagePhrase) {
        this.curItem.element.setAttribute("usage", "computational");
        this.curItem.element.setAttribute("numeric", "true");
    }

    public void inAComp1UsagePhrase(AComp1UsagePhrase aComp1UsagePhrase) {
        this.curItem.element.setAttribute("usage", "computational-1");
        this.curItem.element.setAttribute("numeric", "true");
    }

    public void inAComp2UsagePhrase(AComp2UsagePhrase aComp2UsagePhrase) {
        this.curItem.element.setAttribute("usage", "computational-2");
        this.curItem.element.setAttribute("numeric", "true");
    }

    public void inAComp3UsagePhrase(AComp3UsagePhrase aComp3UsagePhrase) {
        this.curItem.element.setAttribute("usage", "computational-3");
        this.curItem.element.setAttribute("numeric", "true");
    }

    public void inAComp4UsagePhrase(AComp4UsagePhrase aComp4UsagePhrase) {
        this.curItem.element.setAttribute("usage", "computational-4");
        this.curItem.element.setAttribute("numeric", "true");
    }

    public void inAComp5UsagePhrase(AComp5UsagePhrase aComp5UsagePhrase) {
        this.curItem.element.setAttribute("usage", "computational-5");
        this.curItem.element.setAttribute("numeric", "true");
    }

    public void inAComp6UsagePhrase(AComp6UsagePhrase aComp6UsagePhrase) {
        this.curItem.element.setAttribute("usage", "computational-6");
        this.curItem.element.setAttribute("numeric", "true");
    }

    public void inADisplayUsagePhrase(ADisplayUsagePhrase aDisplayUsagePhrase) {
        this.curItem.element.setAttribute("usage", "display");
    }

    public void inADisplay1UsagePhrase(ADisplay1UsagePhrase aDisplay1UsagePhrase) {
        this.curItem.element.setAttribute("usage", "display-1");
    }

    public void inAIndexUsagePhrase(AIndexUsagePhrase aIndexUsagePhrase) {
        this.curItem.element.setAttribute("usage", "index");
    }

    public void inANationalUsagePhrase(ANationalUsagePhrase aNationalUsagePhrase) {
        this.curItem.element.setAttribute("usage", "national");
    }

    public void inAObjectReferencePhrase(AObjectReferencePhrase aObjectReferencePhrase) {
        this.curItem.element.setAttribute("object-reference", aObjectReferencePhrase.getDataName().getText());
    }

    public void inAPackedDecimalUsagePhrase(APackedDecimalUsagePhrase aPackedDecimalUsagePhrase) {
        this.curItem.element.setAttribute("usage", "packed-decimal");
    }

    public void inAPointerUsagePhrase(APointerUsagePhrase aPointerUsagePhrase) {
        this.curItem.element.setAttribute("usage", "pointer");
    }

    public void inAProcedurePointerUsagePhrase(AProcedurePointerUsagePhrase aProcedurePointerUsagePhrase) {
        this.curItem.element.setAttribute("usage", "procedure-pointer");
    }

    public void inAFunctionPointerUsagePhrase(AFunctionPointerUsagePhrase aFunctionPointerUsagePhrase) {
        this.curItem.element.setAttribute("usage", "function-pointer");
    }

    public void caseTZeros(TZeros tZeros) {
        tZeros.setText("zeros");
    }

    public void caseTSpaces(TSpaces tSpaces) {
        tSpaces.setText("spaces");
    }

    public void caseTHighValues(THighValues tHighValues) {
        tHighValues.setText("high-values");
    }

    public void caseTLowValues(TLowValues tLowValues) {
        tLowValues.setText("low-values");
    }

    public void caseTQuotes(TQuotes tQuotes) {
        tQuotes.setText("quotes");
    }

    public void caseTNulls(TNulls tNulls) {
        tNulls.setText("nulls");
    }

    public void caseTAlphanumericLiteral(TAlphanumericLiteral tAlphanumericLiteral) {
        String string = tAlphanumericLiteral.getText();
        if (string.startsWith("X")) {
            tAlphanumericLiteral.setText(string.replace('\"', '\''));
        } else if (string.indexOf("\"") != -1) {
            tAlphanumericLiteral.setText(this.removeChars(string, "\""));
        } else {
            tAlphanumericLiteral.setText(this.removeChars(string, "'"));
        }
    }

    public void outAValueClause(AValueClause aValueClause) {
        this.curItem.element.setAttribute("value", aValueClause.getLiteral().toString().trim());
    }

    public void inAValueItem(AValueItem aValueItem) {
        String string = aValueItem.getDataName().getText();
        this.curItem = new Item();
        this.curItem.element = this.document.createElement("condition");
        this.curItem.element.setAttribute("name", string);
        this.prevItem.element.appendChild(this.curItem.element);
    }

    public void outASingleLiteralSequence(ASingleLiteralSequence aSingleLiteralSequence) {
        if (aSingleLiteralSequence.getAll() != null) {
            this.curItem.element.setAttribute("all", "true");
        }
        Element element = this.document.createElement("condition");
        element.setAttribute("value", aSingleLiteralSequence.getLiteral().toString().trim());
        this.curItem.element.appendChild(element);
    }

    public void outASequenceLiteralSequence(ASequenceLiteralSequence aSequenceLiteralSequence) {
        Element element = this.document.createElement("condition");
        element.setAttribute("value", aSequenceLiteralSequence.getLiteral().toString().trim());
        this.curItem.element.appendChild(element);
    }

    public void outAThroughSingleLiteralSequence(AThroughSingleLiteralSequence aThroughSingleLiteralSequence) {
        Element element = this.document.createElement("condition");
        element.setAttribute("value", aThroughSingleLiteralSequence.getFrom().toString().trim());
        element.setAttribute("through", aThroughSingleLiteralSequence.getTo().toString().trim());
        this.curItem.element.appendChild(element);
    }

    public void outAThroughSequenceLiteralSequence(AThroughSequenceLiteralSequence aThroughSequenceLiteralSequence) {
        Element element = this.document.createElement("condition");
        element.setAttribute("value", aThroughSequenceLiteralSequence.getFrom().toString().trim());
        element.setAttribute("through", aThroughSequenceLiteralSequence.getTo().toString().trim());
        this.curItem.element.appendChild(element);
    }

    private String removeChars(String string, String string2) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
        StringBuffer stringBuffer = new StringBuffer();
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append(stringTokenizer.nextElement());
        }
        return stringBuffer.toString();
    }

    private int postProcessNode(Element element, int n) {
        int n2;
        Object object;
        Object object2;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        String string = "";
        if (element.hasAttribute("usage")) {
            string = element.getAttribute("usage");
        }
        if (element.hasAttribute("redefines")) {
            object2 = element.getAttribute("redefines");
            Element element2 = null;
            object = this.document.getDocumentElement().getElementsByTagName("item");
            for (int i = 0; i < object.getLength(); ++i) {
                Element element3 = (Element)object.item(i);
                if (!element3.getAttribute("name").equalsIgnoreCase((String)object2)) continue;
                element2 = element3;
                break;
            }
            if (element2 != null && element2.hasAttribute("position")) {
                n = Integer.parseInt(element2.getAttribute("position"));
                element2.setAttribute("redefined", "true");
            } else {
                System.out.println(">> position error " + element.getAttribute("name") + " %% " + (String)object2);
            }
        }
        int n6 = n;
        if (element.hasAttribute("display-length")) {
            n4 = Integer.parseInt(element.getAttribute("display-length"));
            if (element.hasAttribute("assumed-digits")) {
                n5 = Integer.parseInt(element.getAttribute("assumed-digits"));
            }
        } else {
            object2 = element.getChildNodes();
            for (int i = 0; i < object2.getLength(); ++i) {
                Element element4;
                object = object2.item(i);
                if (object.getNodeType() == 1 && !(element4 = (Element)object).getTagName().equals("condition")) {
                    n6 = this.postProcessNode(element4, n6);
                }
                n4 = n6 - n;
            }
        }
        n3 = this.setLength(element, !"true".equals(element.getAttribute("signed")), n4, n5);
        int n7 = 1;
        if (element.hasAttribute("sync") && (n2 = (n - 1) % (n7 = this.numDef.getSyncAt(string, n3))) > 0) {
            n = n - n2 + n7;
        }
        element.setAttribute("position", n + "");
        if (element.hasAttribute("occurs")) {
            n3 *= Integer.parseInt(element.getAttribute("occurs"));
        }
        return n + n3;
    }

    private int setLength(Element element, boolean bl, int n, int n2) {
        int n3 = n - n2;
        if (element.hasAttribute("usage")) {
            if (this.numDef != null) {
                String string = element.getAttribute("usage");
                n = this.numDef.chkStorageLength(n, string);
                n3 = this.numDef.getBinarySize(string, n3, bl, element.hasAttribute("sync"));
            }
        } else if (element.hasAttribute("sign-separate") && "true".equalsIgnoreCase(element.getAttribute("sign-separate"))) {
            ++n3;
            ++n;
        }
        element.setAttribute("display-length", n + "");
        element.setAttribute("storage-length", n3 + "");
        if (n2 != 0) {
            element.setAttribute("assumed-digits", n2 + "");
        }
        return n3;
    }

    public static void setNumericDetails(NumericDefinition numericDefinition) {
        defaultNumDef = numericDefinition;
    }

    class Item {
        int level;
        Element element;

        Item(int n, String string) {
            this.level = n;
            this.element = CopyBookAnalyzer.this.document.createElement("item");
            this.element.setAttribute("level", new DecimalFormat("00").format(n));
            this.element.setAttribute("name", string);
        }

        Item() {
        }
    }
}

