/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.jdbccomm.struct;

import de.ubs.jdbcserver.jdbccomm.struct.AbstractItem;
import de.ubs.jdbcserver.jdbccomm.struct.Field;
import de.ubs.jdbcserver.jdbccomm.struct.Item;
import de.ubs.jdbcserver.jdbccomm.struct.ItemPath;
import de.ubs.jdbcserver.jdbccomm.struct.Section;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class TablespaceLayout {
    public static final String START_SECTION_NAME = "start";
    public static final String REMAINING_BYTES = "REMAINING_BYTES";
    protected Section startSection = new Section(null, "start");
    private String fileName = null;
    private Charset charset = Charset.defaultCharset();
    private Map<ItemPath, List<Integer>> pathIndexMap;

    public static Field findOccurrenceCounterField(Item currentItem, String name) {
        while (currentItem != null) {
            Item item = currentItem.getItem(name);
            if (item != null) {
                if (item instanceof Field) {
                    Field field = (Field)item;
                    return field;
                }
                throw new RuntimeException("Occurrence counter field " + name + " is not a field, but a section");
            }
            currentItem = currentItem.getParent();
        }
        return null;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public AbstractItem getItem(ItemPath path) {
        if (REMAINING_BYTES.equals(path.getPathElements()[0])) {
            Field tillEndOfrecorsField = new Field(null, REMAINING_BYTES, "BINARY", 32768, 0, 0);
            return tillEndOfrecorsField;
        }
        AbstractItem matchedItem = null;
        Section current = this.getStartSection();
        for (String pathElement : path.getPathElements()) {
            AbstractItem item = current.getItem(pathElement);
            if (item == null) {
                return null;
            }
            matchedItem = item;
            if (!(item instanceof Section)) continue;
            current = (Section)item;
        }
        return matchedItem;
    }

    public Field getField(ItemPath path) {
        AbstractItem item = this.getItem(path);
        if (item instanceof Field) {
            return (Field)item;
        }
        return null;
    }

    public List<Integer> getFieldIndexes(ItemPath path) {
        if (this.pathIndexMap == null) {
            this.pathIndexMap = new HashMap<ItemPath, List<Integer>>();
            this.calculcateFieldIndexes();
        }
        return this.pathIndexMap.get(path);
    }

    private void calculcateFieldIndexes() {
        HashMap<ItemPath, Integer> tempMap = new HashMap<ItemPath, Integer>();
        ArrayList<AbstractItem> todo = new ArrayList<AbstractItem>();
        todo.add(this.getStartSection());
        int currentIndex = 0;
        while (!todo.isEmpty()) {
            AbstractItem i = (AbstractItem)todo.remove(0);
            if (i.getRedefine() != null) {
                ItemPath referencedField = i.getFieldPath().copyAndExchange(i.getFieldPath().size() - 1, i.getRedefine());
                if (!tempMap.containsKey(referencedField)) {
                    throw new RuntimeException("The referenced field " + referencedField.toString() + " has not been processed yet");
                }
                currentIndex = (Integer)tempMap.get(referencedField);
            }
            ItemPath path = i.getFieldPath();
            tempMap.put(path, currentIndex);
            if (i instanceof Section) {
                todo.addAll(0, ((Section)i).getItems());
                continue;
            }
            if (i instanceof Field) {
                List<Integer> list = this.pathIndexMap.get(path);
                if (list == null) {
                    list = new LinkedList<Integer>();
                    this.pathIndexMap.put(path, list);
                }
                list.add(currentIndex);
                ++currentIndex;
                continue;
            }
            throw new RuntimeException("Unsupported action");
        }
    }

    public Charset getDefaultStringEncoding() {
        return this.charset;
    }

    public void setDefaultStringEncoding(String defaultStringEncoding) {
        this.charset = Charset.forName(defaultStringEncoding);
    }

    public Section getStartSection() {
        return this.startSection;
    }

    public void setStartSection(Section startSection) {
        this.startSection = startSection;
    }

    public List<Item> getAllItems() {
        return this.getAllItems(this.startSection);
    }

    private List<Item> getAllItems(Section section) {
        LinkedList<Item> outputList = new LinkedList<Item>();
        for (AbstractItem item : section.getItems()) {
            outputList.add(item);
            if (!(item instanceof Section)) continue;
            Section subsection = (Section)item;
            outputList.addAll(this.getAllItems(subsection));
        }
        return outputList;
    }
}

