/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.file;

import de.ubs.jdbcserver.file.AbstractModifiableCsvFile;
import de.ubs.jdbcserver.file.CsvFileReader;
import de.ubs.jdbcserver.file.CsvFileWriter;
import de.ubs.jdbcserver.file.UnixCsvFileReader;
import de.ubs.jdbcserver.file.UnixCsvFileWriter;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.GroupPrincipal;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.UserPrincipal;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModifiableUnixCsvFile
extends AbstractModifiableCsvFile {
    private final File file;
    private UserPrincipal fileOwner;
    private GroupPrincipal fileOwnerGroup;
    private Set<PosixFilePermission> filePermissions;

    public ModifiableUnixCsvFile(File f, TablespaceDefinition ts, TableDefinition tb) throws IOException {
        this(f, ts.getLayout().getDefaultStringEncoding(), ts.getCSVColumnDelimiter(), ts.getCSVStringDelimiter(), ts.getCSVQuoteMode(), ts.isReadOnly(), ts.getCSVCacheSize(), ts.isStrictEncoding(), ts.isCSVHeader(), ModifiableUnixCsvFile.columnNamesToStringArray(tb.getColumns()));
    }

    ModifiableUnixCsvFile(File f, Charset encoding, char columnDelimiter, char stringDelimiter, TablespaceDefinition.CsvQuoteMode csvQuoteMode, boolean readOnly, int cacheSize, boolean strictEncoding, boolean withHeader, String[] colNames) throws IOException {
        super(encoding, columnDelimiter, stringDelimiter, csvQuoteMode, readOnly, cacheSize, strictEncoding, withHeader, colNames);
        this.file = f;
        Path filePath = f.toPath();
        if (!Files.isReadable(filePath)) {
            if (Files.exists(filePath, new LinkOption[0])) {
                Logger.getLogger(ModifiableUnixCsvFile.class.getName()).log(Level.FINE, String.format("File %s is not readable even though it exists", filePath));
                throw new IOException("Cannot access " + f.getAbsolutePath() + ": file exists, but reading is not allowed");
            }
            Logger.getLogger(ModifiableUnixCsvFile.class.getName()).log(Level.FINE, String.format("Trying to create file %s", filePath));
            if (filePath.getParent() != null) {
                try {
                    Files.createDirectories(filePath.getParent(), new FileAttribute[0]);
                }
                catch (IOException ex) {
                    throw new IOException("Cannot access " + f.getAbsolutePath() + ": directory " + filePath.getParent() + " does not exist and cannot be created", ex);
                }
            }
            try {
                Files.createFile(filePath, new FileAttribute[0]);
                this.writeHeader();
                Logger.getLogger(ModifiableUnixCsvFile.class.getName()).log(Level.FINE, String.format("File %s created successfully", filePath));
            }
            catch (IOException ex) {
                throw new IOException("Cannot access " + f.getAbsolutePath() + ": file does not exist and cannot be created", ex);
            }
        }
        if (Files.size(f.toPath()) == 0L) {
            this.writeHeader();
        }
        this.in = this.createNewReader(false);
        if (!Files.isWritable(filePath)) {
            this.readOnly = true;
        }
        this.fetchFileAttributes();
        this.filenameForMessages = f.getAbsolutePath();
    }

    private void fetchFileAttributes() {
        if (this.file == null) {
            return;
        }
        try {
            this.fileOwner = Files.getOwner(this.file.toPath(), LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException | SecurityException | UnsupportedOperationException ex) {
            this.fileOwner = null;
        }
        try {
            this.fileOwnerGroup = Files.readAttributes(this.file.toPath(), PosixFileAttributes.class, LinkOption.NOFOLLOW_LINKS).group();
        }
        catch (IOException | SecurityException | UnsupportedOperationException ex) {
            this.fileOwnerGroup = null;
        }
        try {
            this.filePermissions = Files.getPosixFilePermissions(this.file.toPath(), LinkOption.NOFOLLOW_LINKS);
        }
        catch (IOException | SecurityException | UnsupportedOperationException ex) {
            this.filePermissions = null;
        }
    }

    private void restoreFileAttributes() {
        if (this.file == null) {
            return;
        }
        if (this.fileOwner != null) {
            try {
                Files.setOwner(this.file.toPath(), this.fileOwner);
            }
            catch (IOException | SecurityException | UnsupportedOperationException exception) {
                // empty catch block
            }
        }
        if (this.fileOwnerGroup != null) {
            try {
                Files.getFileAttributeView(this.file.toPath(), PosixFileAttributeView.class, LinkOption.NOFOLLOW_LINKS).setGroup(this.fileOwnerGroup);
            }
            catch (IOException | SecurityException | UnsupportedOperationException exception) {
                // empty catch block
            }
        }
        if (this.filePermissions != null) {
            try {
                Files.setPosixFilePermissions(this.file.toPath(), this.filePermissions);
            }
            catch (IOException | SecurityException | UnsupportedOperationException exception) {
                // empty catch block
            }
        }
    }

    @Override
    protected CsvFileReader createNewReader(boolean forFlush) throws IOException {
        CsvFileReader.HeaderProcessingMode headerProcessingMode = this.firstLineIsHeader ? (forFlush ? CsvFileReader.HeaderProcessingMode.READ_BUT_DO_NOT_COUNT : CsvFileReader.HeaderProcessingMode.SKIP_AND_DO_NOT_COUNT) : CsvFileReader.HeaderProcessingMode.READ_AND_COUNT;
        UnixCsvFileReader r = new UnixCsvFileReader(this.file, this.encoding, this.csvQuoteMode == TablespaceDefinition.CsvQuoteMode.NONE ? (char)'\u0000' : this.stringDelimiter, this.maximumRecordLength, this.codingErrorAction, headerProcessingMode);
        this.lineSeparator = r.getDetectedLineSeparator();
        return r;
    }

    @Override
    protected CsvFileWriter createNewWriter() throws IOException {
        return new UnixCsvFileWriter(this.file, this.encoding);
    }

    @Override
    protected void applyDelta() throws IOException, SQLException {
        String line;
        if (this.closed) {
            throw new RuntimeException("Internal error: applyDelta() was called but file is closed");
        }
        if (this.deltaMap.isEmpty()) {
            return;
        }
        if (this.out != null) {
            this.out.close();
            this.out = null;
        }
        long cursorPosition = this.in.getRecordNumber();
        this.in.close();
        this.in = this.createNewReader(true);
        File parentDirectory = this.file.getAbsoluteFile().getParentFile();
        File shadowFile = File.createTempFile(this.file.getName() + "-shadow-", "", parentDirectory);
        try (BufferedWriter shadowWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(shadowFile), this.encoding));){
            String record;
            Map.Entry delta = this.deltaMap.pollFirstEntry();
            while ((record = this.in.readRecord()) != null) {
                if (delta != null && ((Long)delta.getKey()).longValue() == this.in.getRecordNumber()) {
                    if (delta.getValue() == null) {
                        if (this.in.getRecordNumber() <= cursorPosition) {
                            --cursorPosition;
                        }
                    } else {
                        shadowWriter.write((String)delta.getValue() + this.lineSeparator);
                    }
                    delta = this.deltaMap.pollFirstEntry();
                    continue;
                }
                shadowWriter.write(record + this.lineSeparator);
            }
        }
        this.in.close();
        this.currentDeltaMapSizeInBytes = 0;
        File tempFile = new File(this.file.getAbsolutePath() + ".old");
        if (!this.file.renameTo(tempFile)) {
            throw new RuntimeException(String.format("Could not rename %s to %s", this.file.getName(), tempFile.getName()));
        }
        if (!shadowFile.renameTo(this.file)) {
            throw new RuntimeException(String.format("Could not rename %s to %s", shadowFile.getName(), this.file.getName()));
        }
        this.restoreFileAttributes();
        tempFile.delete();
        this.in = this.createNewReader(false);
        while (this.in.getRecordNumber() < cursorPosition && (line = this.in.readRecord()) != null) {
        }
        ++this.flushCount;
    }

    @Override
    public String getName() {
        return this.file.getName();
    }
}

