/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.evaluation;

import de.ubs.jdbcserver.Server;
import de.ubs.jdbcserver.command.sql.ParameterValueData;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccomm.util.ComparableByteArray;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserBaseVisitor;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.struct.CatalogManager;
import de.ubs.jdbcserver.jdbccommons.struct.TablespaceDefinition;
import de.ubs.jdbcserver.splitter.CSVRecordSplitter;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class EvaluationVisitor
extends SQLParserBaseVisitor<Comparable> {
    private static final FastDateFormat TIMESTAMP_PARSER = FastDateFormat.getInstance("yyyy-MM-dd-HH:mm:ss.SSS");
    private static final FastDateFormat TIME_PARSER = FastDateFormat.getInstance("HH:mm:ss");
    private static final FastDateFormat DATE_PARSER = FastDateFormat.getInstance("yyyy-MM-dd");
    private static final Pattern DATE_PATTERN = Pattern.compile("[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}");
    private static final Pattern TIME_PATTERN = Pattern.compile("[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}");
    private static final Pattern TIMESTAMP_PATTERN = Pattern.compile("[0-9]{4}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-[0-9]{2}\\-([0-9]{1,3}\\-)?");
    private final Map<String, Comparable> fieldContents = new HashMap<String, Comparable>();
    private final Map<String, Integer> referencedWhereColumns = new HashMap<String, Integer>();
    private final TableDefinition tableDefinition;
    private final Map<String, Pattern> likePatternMap = new HashMap<String, Pattern>();
    private ParameterValueData parameterMarkerContents;
    private Charset charset;
    private ParserRuleContext tree;

    EvaluationVisitor(TableDefinition table, ParameterValueData parameterMarkerContents, ParserRuleContext tree) throws SQLException {
        TablespaceDefinition tablespace;
        if (table != null && (tablespace = CatalogManager.getDefault().getTablespace(table.getTablespaceName())) != null) {
            this.charset = tablespace.getLayout().getDefaultStringEncoding();
        }
        this.tableDefinition = table;
        this.parameterMarkerContents = parameterMarkerContents;
        this.setParsedTree(tree);
    }

    public ParameterValueData getParameterMarkerContents() {
        return this.parameterMarkerContents;
    }

    public void setParameterMarkerContents(ParameterValueData parameterMarkerContents) {
        this.parameterMarkerContents = parameterMarkerContents;
    }

    public ParserRuleContext getTree() {
        return this.tree;
    }

    public Map<String, Integer> getReferencedWhereColumns() {
        return this.referencedWhereColumns;
    }

    public final void setParsedTree(ParserRuleContext tree) throws SQLException {
        this.tree = tree;
        this.referencedWhereColumns.clear();
        if (tree != null && this.tableDefinition != null) {
            MyVisitor v = new MyVisitor();
            v.visitChildren(tree);
            if (v.e != null) {
                throw v.e;
            }
        }
    }

    public void setValue(String columnName, Comparable value) {
        this.fieldContents.put(columnName, value);
    }

    @Override
    public Comparable visitProduct(SQLParserParser.ProductContext ctx) {
        Comparable atom = this.visitAtom(ctx.atom());
        if (atom == null) {
            return null;
        }
        if (ctx.product() != null) {
            BigDecimal atomBigDecimal = (BigDecimal)atom;
            BigDecimal productResult = (BigDecimal)this.visitProduct(ctx.product());
            if (productResult == null) {
                return null;
            }
            if (ctx.DIVIDE() != null) {
                return atomBigDecimal.divide(productResult);
            }
            return atomBigDecimal.multiply(productResult);
        }
        return atom;
    }

    @Override
    public Comparable visitSum(SQLParserParser.SumContext ctx) {
        Comparable product = this.visitProduct(ctx.product());
        if (product == null) {
            return product;
        }
        if (ctx.sum() != null) {
            BigDecimal productBigDecimal = (BigDecimal)product;
            BigDecimal sumResult = (BigDecimal)this.visitSum(ctx.sum());
            if (sumResult == null) {
                return sumResult;
            }
            if (ctx.MINUS() != null) {
                return productBigDecimal.subtract(sumResult);
            }
            return productBigDecimal.add(sumResult);
        }
        return product;
    }

    @Override
    public Comparable visitColumn(SQLParserParser.ColumnContext ctx) {
        String columnName = ctx.identifier().value;
        Comparable rawValue = this.fieldContents.get(columnName);
        if (rawValue instanceof byte[]) {
            return new ComparableByteArray((byte[])rawValue);
        }
        return rawValue;
    }

    @Override
    public Comparable visitCaseStatement(SQLParserParser.CaseStatementContext ctx) {
        if (ctx.simpleCaseStatement() != null) {
            return this.visitSimpleCaseStatement(ctx.simpleCaseStatement());
        }
        if (ctx.complexCaseStatement() != null) {
            return this.visitComplexCaseStatement(ctx.complexCaseStatement());
        }
        throw new RuntimeException("Internal error");
    }

    @Override
    public Comparable visitSimpleCaseStatement(SQLParserParser.SimpleCaseStatementContext ctx) {
        Comparable compareValue = this.visitColRef(ctx.colRef());
        for (int i = 0; i < ctx.sum().size(); i += 2) {
            Comparable whenValue = this.visitSum(ctx.sum(i));
            if (!Objects.equals(compareValue, whenValue)) continue;
            return this.visitSum(ctx.sum(i + 1));
        }
        if (ctx.elseClause() != null) {
            return this.visitSum(ctx.elseClause().sum());
        }
        throw new UncheckedSQLException("Case not found for CASE statement", "20000", -773);
    }

    @Override
    public Comparable visitComplexCaseStatement(SQLParserParser.ComplexCaseStatementContext ctx) {
        for (int i = 0; i < ctx.disjunction().size(); ++i) {
            Comparable condition = this.visitDisjunction(ctx.disjunction(i));
            if (!((Boolean)condition).booleanValue()) continue;
            return this.visitSum(ctx.sum(i));
        }
        if (ctx.elseClause() != null) {
            return this.visitSum(ctx.elseClause().sum());
        }
        throw new UncheckedSQLException("Case not found for CASE statement", "20000", -773);
    }

    @Override
    public Comparable visitColRef(SQLParserParser.ColRefContext ctx) {
        return this.visitSum(ctx.sum());
    }

    @Override
    public Comparable visitColumnFunction(SQLParserParser.ColumnFunctionContext ctx) {
        if (ctx.HEX() != null) {
            Comparable value = this.visitColRef(ctx.colRef(0));
            if (value == null) {
                return null;
            }
            if (value instanceof ComparableByteArray) {
                return Hex.encodeHexString(((ComparableByteArray)value).getByteArray()).toUpperCase();
            }
            byte[] bytes = value.toString().getBytes(this.charset);
            return Hex.encodeHexString(bytes).toUpperCase();
        }
        if (ctx.LENGTH() != null) {
            Comparable value = this.visitColRef(ctx.colRef(0));
            if (value == null) {
                return null;
            }
            return Integer.valueOf(value.toString().getBytes(this.charset).length);
        }
        if (ctx.MAX() != null) {
            Comparable max = null;
            for (SQLParserParser.ColRefContext colRef : ctx.colRef()) {
                Comparable x = this.visitColRef(colRef);
                if (x == null || max != null && max.compareTo(x) >= 0) continue;
                max = x;
            }
            return max;
        }
        if (ctx.MIN() != null) {
            Comparable min = null;
            for (SQLParserParser.ColRefContext colRef : ctx.colRef()) {
                Comparable x = this.visitColRef(colRef);
                if (x == null || min != null && min.compareTo(x) <= 0) continue;
                min = x;
            }
            return min;
        }
        if (ctx.SUBSTR() != null) {
            Comparable x = this.visitColRef(ctx.colRef(0));
            if (x == null) {
                return null;
            }
            String value = x.toString();
            Comparable startOffsetBd = this.visitSum(ctx.sum(0));
            if (startOffsetBd == null) {
                return null;
            }
            int startOffset = ((BigDecimal)startOffsetBd).intValue() - 1;
            int length = -1;
            if (ctx.sum().size() > 1) {
                Comparable lengthBd = this.visitSum(ctx.sum(1));
                if (lengthBd == null) {
                    throw new UncheckedSQLException("NULL is not valid in the context where it is used.", "42703", -206);
                }
                length = ((BigDecimal)lengthBd).intValue();
            }
            if (length == -1) {
                return value.substring(startOffset);
            }
            return value.substring(startOffset, startOffset + length);
        }
        if (ctx.BITAND() != null) {
            long sum1 = this.getLongValue(this.visitSum(ctx.sum(0)));
            long sum2 = this.getLongValue(this.visitSum(ctx.sum(1)));
            return new BigDecimal(sum1 & sum2);
        }
        if (ctx.BITOR() != null) {
            long sum1 = this.getLongValue(this.visitSum(ctx.sum(0)));
            long sum2 = this.getLongValue(this.visitSum(ctx.sum(1)));
            return new BigDecimal(sum1 | sum2);
        }
        if (ctx.BITXOR() != null) {
            long sum1 = this.getLongValue(this.visitSum(ctx.sum(0)));
            long sum2 = this.getLongValue(this.visitSum(ctx.sum(1)));
            return new BigDecimal(sum1 ^ sum2);
        }
        if (ctx.BITNOT() != null) {
            long sum = this.getLongValue(this.visitSum(ctx.sum(0)));
            return new BigDecimal(sum ^ 0xFFFFFFFFFFFFFFFFL);
        }
        if (ctx.UPPER() != null) {
            Comparable value = this.visitColRef(ctx.colRef(0));
            if (value == null) {
                return null;
            }
            return value.toString().toUpperCase();
        }
        if (ctx.LOWER() != null) {
            Comparable value = this.visitColRef(ctx.colRef(0));
            if (value == null) {
                return null;
            }
            return value.toString().toLowerCase();
        }
        if (ctx.STRIP() != null) {
            Comparable value = this.visitColRef(ctx.colRef(0));
            if (value == null) {
                return null;
            }
            if (ctx.StringLiteral() == null || ctx.StringLiteral().isEmpty()) {
                return value.toString().trim();
            }
            int which = 66;
            String trimChar = " ";
            if (ctx.StringLiteral().size() >= 1) {
                String whichStr = CSVRecordSplitter.unescapeSqlStringLiteral(ctx.StringLiteral(0).getText()).trim().toUpperCase();
                if (whichStr.equals("B") || whichStr.equals("BOTH")) {
                    which = 66;
                } else if (whichStr.equals("L") || whichStr.equals("LEADING")) {
                    which = 76;
                } else if (whichStr.equals("T") || whichStr.equals("TRAILING")) {
                    which = 84;
                } else {
                    throw new UncheckedSQLException("The data type, length, or value of argument 2 of STRIP is invalid", "42815", -171);
                }
            }
            if (ctx.StringLiteral().size() >= 2 && (trimChar = CSVRecordSplitter.unescapeSqlStringLiteral(ctx.StringLiteral(1).getText())).length() != 1) {
                throw new UncheckedSQLException("The data type, length, or value of argument 3 of STRIP is invalid", "42815", -171);
            }
            switch (which) {
                case 76: {
                    return StringUtils.stripStart(value.toString(), trimChar);
                }
                case 84: {
                    return StringUtils.stripEnd(value.toString(), trimChar);
                }
            }
            return StringUtils.strip(value.toString(), trimChar);
        }
        if (ctx.TO_CHAR() != null) {
            Comparable value = this.visitColRef(ctx.colRef(0));
            if (value == null) {
                return null;
            }
            boolean isDate = value instanceof Date;
            boolean isTime = value instanceof Time;
            boolean isTimestamp = value instanceof Timestamp;
            if (!(isDate || isTime || isTimestamp)) {
                if (ctx.StringLiteral() != null && ctx.StringLiteral(0) != null) {
                    throw new UncheckedSQLException(String.format("The date, time, or timestamp value '%s' is invalid", value.toString()), "22007", -180);
                }
                return value.toString();
            }
            FastDateFormat dateFormat = null;
            if (ctx.StringLiteral() == null || ctx.StringLiteral().isEmpty()) {
                if (isDate) {
                    dateFormat = DATE_PARSER;
                } else if (isTime) {
                    dateFormat = TIME_PARSER;
                } else if (isTimestamp) {
                    dateFormat = TIMESTAMP_PARSER;
                }
            } else {
                String formatString = CSVRecordSplitter.unescapeSqlStringLiteral(ctx.StringLiteral(0).getText());
                dateFormat = FastDateFormat.getInstance(formatString);
            }
            if (isDate) {
                return dateFormat.format((Date)value);
            }
            if (isTime) {
                return dateFormat.format((Time)value);
            }
            if (isTimestamp) {
                return dateFormat.format((Timestamp)value);
            }
            throw new UncheckedSQLException(String.format("The date, time, or timestamp value '%s' is invalid", value.toString()), "22007", -180);
        }
        if (ctx.TO_DATE() != null) {
            Comparable value = this.visitColRef(ctx.colRef(0));
            if (value == null) {
                return null;
            }
            FastDateFormat dateFormat = null;
            if (ctx.StringLiteral() == null || ctx.StringLiteral().isEmpty()) {
                dateFormat = DATE_PARSER;
            } else {
                String formatString = CSVRecordSplitter.unescapeSqlStringLiteral(ctx.StringLiteral(0).getText());
                dateFormat = FastDateFormat.getInstance(formatString);
            }
            try {
                return new Date(dateFormat.parse(value.toString()).getTime());
            }
            catch (ParseException ex) {
                throw new UncheckedSQLException(String.format("The date, time, or timestamp value '%s' is invalid", value.toString()), "22007", -180);
            }
        }
        if (ctx.TO_TIME() != null) {
            Comparable value = this.visitColRef(ctx.colRef(0));
            if (value == null) {
                return null;
            }
            FastDateFormat dateFormat = null;
            if (ctx.StringLiteral() == null || ctx.StringLiteral().isEmpty()) {
                dateFormat = TIME_PARSER;
            } else {
                String formatString = CSVRecordSplitter.unescapeSqlStringLiteral(ctx.StringLiteral(0).getText());
                dateFormat = FastDateFormat.getInstance(formatString);
            }
            try {
                return new Time(dateFormat.parse(value.toString()).getTime());
            }
            catch (ParseException ex) {
                throw new UncheckedSQLException(String.format("The date, time, or timestamp value '%s' is invalid", value.toString()), "22007", -180);
            }
        }
        if (ctx.TO_TIMESTAMP() != null) {
            Comparable value = this.visitColRef(ctx.colRef(0));
            if (value == null) {
                return null;
            }
            FastDateFormat dateFormat = null;
            if (ctx.StringLiteral() == null || ctx.StringLiteral().isEmpty()) {
                dateFormat = TIMESTAMP_PARSER;
            } else {
                String formatString = CSVRecordSplitter.unescapeSqlStringLiteral(ctx.StringLiteral(0).getText());
                dateFormat = FastDateFormat.getInstance(formatString);
            }
            try {
                return new Timestamp(dateFormat.parse(value.toString()).getTime());
            }
            catch (ParseException ex) {
                throw new UncheckedSQLException(String.format("The date, time, or timestamp value '%s' is invalid.", value.toString()), "22007", -180);
            }
        }
        if (ctx.CONCAT() != null) {
            Comparable value1 = this.visitColRef(ctx.colRef(0));
            Comparable value2 = this.visitColRef(ctx.colRef(1));
            if (value1 == null || value2 == null) {
                return null;
            }
            return value1.toString() + value2.toString();
        }
        if (ctx.GETVARIABLE() != null) {
            if (ctx.StringLiteral() == null || ctx.StringLiteral().isEmpty()) {
                throw new UncheckedSQLException("The data type, length, or value of argument 1 of GETVARIABLE is invalid", "42815", -171);
            }
            String varName = CSVRecordSplitter.unescapeSqlStringLiteral(ctx.StringLiteral(0).getText()).trim().toUpperCase();
            String defaultValue = null;
            boolean hasDefaultValue = false;
            if (ctx.colRef() != null && !ctx.colRef().isEmpty()) {
                hasDefaultValue = true;
                Comparable c = this.visitColRef(ctx.colRef(0));
                defaultValue = c == null ? null : c.toString();
            }
            String ret = null;
            switch (varName) {
                case "SERVER_BUILD_DATE": {
                    ret = Server.getServerBuildDate();
                    break;
                }
                case "SERVER_OPERATING_SYSTEM": 
                case "SERVER_OS": {
                    ret = String.format("%s %s (%s)", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
                    break;
                }
                case "SERVER_WORKING_DIRECTORY": 
                case "SERVER_WORKING_DIR": {
                    ret = System.getProperty("user.dir");
                    break;
                }
                case "SERVER_DEFAULT_ENCODING": {
                    ret = Charset.defaultCharset().displayName();
                    break;
                }
                default: {
                    if (hasDefaultValue) {
                        ret = defaultValue;
                        break;
                    }
                    throw new UncheckedSQLException("The data type, length, or value of argument 1 of GETVARIABLE is invalid", "42815", -171);
                }
            }
            if (ret == null) {
                return null;
            }
            return ret.length() > 255 ? ret.substring(0, 255) : ret;
        }
        throw new RuntimeException("Internal error");
    }

    private long getLongValue(Comparable c) {
        if (c instanceof ComparableByteArray) {
            ComparableByteArray comparableByteArray = (ComparableByteArray)c;
            long longValue = 0L;
            for (byte b : comparableByteArray.getByteArray()) {
                longValue <<= 8;
                longValue |= (long)b;
            }
            return longValue;
        }
        if (c instanceof BigDecimal) {
            BigDecimal bigDecimal = (BigDecimal)c;
            return bigDecimal.longValue();
        }
        throw new UncheckedSQLException("Could not convert " + c.getClass().getSimpleName() + " to numeric value", "42604", -103);
    }

    @Override
    public Comparable visitParameterMarker(SQLParserParser.ParameterMarkerContext ctx) {
        if (this.parameterMarkerContents == null) {
            throw new RuntimeException("No parameter values provided");
        }
        int parameterMarkerIndex = ctx.no;
        Object value = this.parameterMarkerContents.getLatestValues()[parameterMarkerIndex];
        return (Comparable)value;
    }

    @Override
    public Comparable visitAtom(SQLParserParser.AtomContext ctx) {
        if (ctx.sum() != null) {
            Comparable c = this.visitSum(ctx.sum());
            if (ctx.MINUS() == null || c == null) {
                return c;
            }
            if (c instanceof BigDecimal) {
                return ((BigDecimal)c).negate();
            }
            throw new UncheckedSQLException("An operand of an arithmetic operation or an operand of a function that requires a number is not a number.", "42819", -402);
        }
        if (ctx.parameterMarker() != null) {
            return this.visitParameterMarker(ctx.parameterMarker());
        }
        if (ctx.column() != null) {
            Comparable c = this.visitColumn(ctx.column());
            if (ctx.MINUS() == null || c == null) {
                return c;
            }
            if (c instanceof BigDecimal) {
                return ((BigDecimal)c).negate();
            }
            throw new UncheckedSQLException(String.format("Column %s cannot be used for arithmetic operation", ctx.column().identifier().value), "42819", -402);
        }
        if (ctx.constant() != null) {
            return this.visitConstant(ctx.constant());
        }
        if (ctx.caseStatement() != null) {
            return this.visitCaseStatement(ctx.caseStatement());
        }
        if (ctx.columnFunction() != null) {
            return this.visitColumnFunction(ctx.columnFunction());
        }
        throw new RuntimeException("No viable alternative for atom");
    }

    @Override
    public Comparable visitIdentifier(SQLParserParser.IdentifierContext ctx) {
        String identifierValue = null;
        String text = ctx.getText();
        identifierValue = text.charAt(0) == '\"' ? StringUtils.strip(text, "\"") : text.toUpperCase();
        return identifierValue;
    }

    @Override
    public Comparable visitConstant(SQLParserParser.ConstantContext ctx) {
        if (ctx.NULL() != null) {
            return null;
        }
        if (ctx.StringLiteral() != null) {
            String str = ((String)((Object)ctx.value)).replaceAll("''", "'");
            try {
                if (TIMESTAMP_PATTERN.matcher(str).matches()) {
                    return new Timestamp(TIMESTAMP_PARSER.parse(str).getTime());
                }
                if (DATE_PATTERN.matcher(str).matches()) {
                    return new Timestamp(DATE_PARSER.parse(str).getTime());
                }
                if (TIME_PATTERN.matcher(str).matches()) {
                    return new Timestamp(TIME_PARSER.parse(str).getTime());
                }
            }
            catch (ParseException e) {
                Logger.getLogger(EvaluationVisitor.class.getName()).log(Level.SEVERE, "Failed to parse timestamp {0}", str);
            }
            return str;
        }
        if (ctx.BinaryLiteral() != null) {
            String binRepresentation = (String)((Object)ctx.value);
            return new BigDecimal(Long.parseLong(binRepresentation, 2));
        }
        if (ctx.HexLiteral() != null) {
            String hexRepresentation = (String)((Object)ctx.value);
            try {
                byte[] ret = Hex.decodeHex(hexRepresentation.toCharArray());
                return new ComparableByteArray(ret);
            }
            catch (DecoderException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (ctx.number() != null) {
            return new BigDecimal(ctx.getText());
        }
        throw new RuntimeException("No viable alternative for constant");
    }

    protected Comparable[] resolveConstants(List<SQLParserParser.ConstantContext> list) {
        int idx = 0;
        Comparable[] rc = new Comparable[list.size()];
        for (SQLParserParser.ConstantContext constant : list) {
            rc[idx] = this.visitConstant(constant);
            ++idx;
        }
        return rc;
    }

    @Override
    public Comparable visitBool(SQLParserParser.BoolContext ctx) {
        if (null != ctx.NOT()) {
            return Boolean.valueOf((Boolean)this.visitBool(ctx.bool()) == false);
        }
        if (null != ctx.LPAREN()) {
            return this.visitDisjunction(ctx.disjunction());
        }
        return (Boolean)this.visitEquation(ctx.equation());
    }

    @Override
    public Comparable visitEquation(SQLParserParser.EquationContext ctx) {
        Comparable firstSum = this.visitSum(ctx.sum(0));
        if (firstSum == null) {
            return null;
        }
        if (ctx.IS() != null) {
            return Boolean.valueOf(ctx.NOT() != null);
        }
        if (ctx.IN() != null) {
            if (ctx.NOT() != null) {
                for (Comparable c : this.resolveConstants(ctx.getRuleContexts(SQLParserParser.ConstantContext.class))) {
                    if (firstSum.compareTo(c) != 0) continue;
                    return Boolean.valueOf(false);
                }
                return Boolean.valueOf(true);
            }
            for (Comparable c : this.resolveConstants(ctx.getRuleContexts(SQLParserParser.ConstantContext.class))) {
                if (firstSum.compareTo(c) != 0) continue;
                return Boolean.valueOf(true);
            }
            return Boolean.valueOf(false);
        }
        if (ctx.LIKE() != null) {
            String inputStr = (String)((Object)firstSum);
            String likePattern = StringUtils.strip(ctx.StringLiteral().getText(), "'");
            int wildCardCount = StringUtils.countMatches(likePattern, "%");
            if (wildCardCount == 0) {
                return Boolean.valueOf(inputStr.equals(likePattern));
            }
            if (likePattern.equals("%")) {
                return Boolean.valueOf(true);
            }
            if (likePattern.endsWith("%") && wildCardCount == 1) {
                String patternWithoutWildcard = likePattern.substring(0, likePattern.length() - 1);
                return Boolean.valueOf(inputStr.startsWith(patternWithoutWildcard));
            }
            Pattern pattern = this.likePatternMap.get(likePattern);
            if (pattern == null) {
                String patternStr = likePattern;
                patternStr = patternStr.replace(".", "\\.");
                patternStr = patternStr.replace("(", "\\(");
                patternStr = patternStr.replace(")", "\\)");
                patternStr = patternStr.replace("[", "\\[");
                patternStr = patternStr.replace("]", "\\]");
                patternStr = patternStr.replace("?", "\\?");
                patternStr = patternStr.replace("*", "\\*");
                patternStr = patternStr.replace("^", "\\^");
                patternStr = patternStr.replace("~", "\\~");
                patternStr = patternStr.replace("+", "\\+");
                patternStr = patternStr.replace("-", "\\-");
                patternStr = patternStr.replace("$", "\\$");
                patternStr = patternStr.replace("%", ".*?");
                pattern = Pattern.compile("^" + patternStr + "$");
                this.likePatternMap.put(likePattern, pattern);
                Logger.getLogger(EvaluationVisitor.class.getName()).log(Level.FINE, "Converted LIKE expression {0} to REGEX: {1}", new Object[]{likePattern, patternStr});
            }
            return Boolean.valueOf(pattern.matcher(inputStr).matches());
        }
        Comparable secondSum = this.visitSum(ctx.sum(1));
        if (secondSum == null) {
            throw new RuntimeException("Can not evaluate expression for compare: " + ctx.sum(1).getText());
        }
        if (ctx.operator().OP_EQUALS() != null) {
            return Boolean.valueOf(firstSum.compareTo(secondSum) == 0);
        }
        if (ctx.operator().OP_NOT_EQUALS1() != null || ctx.operator().OP_NOT_EQUALS2() != null) {
            return Boolean.valueOf(firstSum.compareTo(secondSum) != 0);
        }
        if (ctx.operator().OP_GREATER() != null) {
            return Boolean.valueOf(firstSum.compareTo(secondSum) > 0);
        }
        if (ctx.operator().OP_GREATER_THAN_OR_EQUALS() != null) {
            return Boolean.valueOf(firstSum.compareTo(secondSum) >= 0);
        }
        if (ctx.operator().OP_LESS() != null) {
            return Boolean.valueOf(firstSum.compareTo(secondSum) < 0);
        }
        if (ctx.operator().OP_LESS_THAN_OR_EQUALS() != null) {
            return Boolean.valueOf(firstSum.compareTo(secondSum) <= 0);
        }
        throw new RuntimeException("No viable alternative for equation");
    }

    @Override
    public Comparable visitDisjunction(SQLParserParser.DisjunctionContext ctx) {
        if (ctx.disjunction() != null) {
            return Boolean.valueOf((Boolean)this.visitConjunction(ctx.conjunction()) != false || (Boolean)this.visitDisjunction(ctx.disjunction()) != false);
        }
        return (Boolean)this.visitConjunction(ctx.conjunction());
    }

    @Override
    public Comparable visitConjunction(SQLParserParser.ConjunctionContext ctx) {
        Comparable comparable = this.visitBool(ctx.bool());
        if (comparable == null) {
            return Boolean.valueOf(false);
        }
        if (ctx.conjunction() != null) {
            return Boolean.valueOf((Boolean)comparable != false && (Boolean)this.visitConjunction(ctx.conjunction()) != false);
        }
        return (Boolean)comparable;
    }

    class MyVisitor
    extends SQLParserBaseVisitor<Comparable> {
        public SQLException e = null;

        MyVisitor() {
        }

        @Override
        public Comparable visitColumn(SQLParserParser.ColumnContext ctx) {
            String columnName = ctx.identifier().value;
            int indexOf = EvaluationVisitor.this.tableDefinition.indexOfColumn(columnName);
            if (indexOf == -1) {
                this.e = new SQLException("Column " + columnName + " does not exist", "42703", -206);
                return null;
            }
            EvaluationVisitor.this.referencedWhereColumns.put(columnName, indexOf);
            return (Comparable)super.visitColumn(ctx);
        }
    }

    static class UncheckedSQLException
    extends RuntimeException {
        private final String state;
        private final int vendorCode;

        public UncheckedSQLException(String message, String state, int vendorCode) {
            super(message);
            this.state = state;
            this.vendorCode = vendorCode;
        }

        public String getState() {
            return this.state;
        }

        public int getVendorCode() {
            return this.vendorCode;
        }
    }
}

