/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver.accessor.mainframe;

import java.sql.Timestamp;
import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class TimestampFormatter {
    private final FastDateFormat formatter;
    private final String pattern;
    private int firstIndex = -1;
    private int lastIndex = -1;

    public TimestampFormatter(String pattern) {
        int nanoDigitsCount = StringUtils.countMatches(pattern, "S");
        if (nanoDigitsCount > 3) {
            this.firstIndex = pattern.indexOf("S");
            this.lastIndex = pattern.lastIndexOf("S");
            this.pattern = pattern.substring(0, this.firstIndex) + pattern.substring(this.lastIndex + 1);
        } else {
            this.pattern = pattern;
        }
        this.formatter = FastDateFormat.getInstance(this.pattern);
    }

    public String format(Timestamp timestamp) {
        StringBuilder str = new StringBuilder(this.formatter.format(timestamp));
        if (this.firstIndex != -1 && this.lastIndex != -1) {
            String nanoStr = String.format("%d", timestamp.getNanos());
            nanoStr = StringUtils.leftPad(nanoStr, this.lastIndex - this.firstIndex);
            str.insert(this.firstIndex, nanoStr);
        }
        return str.toString();
    }

    public Timestamp parse(String timestampStr) throws ParseException {
        int nanos = -1;
        if (this.firstIndex != -1 && this.lastIndex != -1) {
            nanos = Integer.valueOf(timestampStr.substring(this.firstIndex, this.lastIndex + 1));
            timestampStr = timestampStr.substring(0, this.firstIndex) + timestampStr.substring(this.lastIndex + 1);
            for (int i = this.lastIndex - this.firstIndex + 1; i < 9; ++i) {
                nanos *= 10;
            }
        }
        Date date = this.formatter.parse(timestampStr);
        Timestamp timestamp = new Timestamp(date.getTime());
        if (nanos != -1) {
            timestamp.setNanos(nanos);
        }
        return timestamp;
    }
}

