/*
 * Decompiled with CFR 0.152.
 */
package de.ubs.jdbcserver;

import de.ubs.jdbcserver.evaluation.ExpressionEvaluator;
import de.ubs.jdbcserver.jdbccomm.struct.TableDefinition;
import de.ubs.jdbcserver.jdbccommons.sql.parser.SQLParserParser;
import de.ubs.jdbcserver.jdbccommons.sql.parser.StatementInformation;
import java.sql.SQLException;
import java.util.List;

public class RecordTransformer {
    private ExpressionEvaluator<Object> columnSelector;
    private SQLParserParser.SelectStatementContext selectContext;
    private TableDefinition tableDefinition;

    public RecordTransformer(StatementInformation si, TableDefinition tableDefinition) throws SQLException {
        this.tableDefinition = tableDefinition;
        SQLParserParser.StatementContext context = si.getStatementInformation();
        if (context.selectStatement() != null) {
            this.selectContext = context.selectStatement();
            this.columnSelector = new ExpressionEvaluator(tableDefinition);
        }
    }

    public Object[] getOnlySelectedColumns(Object[] input) throws SQLException {
        if (this.columnSelector == null || this.selectContext.STAR() != null) {
            return input;
        }
        for (int i = 0; i < this.tableDefinition.getColumns().size(); ++i) {
            this.columnSelector.setValue(this.tableDefinition.getColumns().get(i).getName(), (Comparable)input[i]);
        }
        List<SQLParserParser.ColRefContext> selectedColumns = this.selectContext.colRef();
        Object[] output = new Object[selectedColumns.size()];
        for (int i = 0; i < selectedColumns.size(); ++i) {
            output[i] = this.columnSelector.evaluate(selectedColumns.get(i));
        }
        return output;
    }
}

