/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jzos.fields;

import com.ibm.jzos.fields.LongAccessor;

public class BinaryAsLongField
implements LongAccessor {
    public static final int MAX_FIELD_WIDTH = 8;
    public static final int DEFAULT_FIELD_WIDTH = 8;
    public static final long SIGNED_MIN_LEN1_VAL = -128L;
    public static final long SIGNED_MAX_LEN1_VAL = 127L;
    public static final long SIGNED_MIN_LEN2_VAL = -32768L;
    public static final long SIGNED_MAX_LEN2_VAL = 32767L;
    public static final long SIGNED_MIN_LEN3_VAL = -8388608L;
    public static final long SIGNED_MAX_LEN3_VAL = 0x7FFFFFL;
    public static final long SIGNED_MIN_LEN4_VAL = Integer.MIN_VALUE;
    public static final long SIGNED_MAX_LEN4_VAL = Integer.MAX_VALUE;
    public static final long SIGNED_MIN_LEN5_VAL = -549755813888L;
    public static final long SIGNED_MAX_LEN5_VAL = 0x7FFFFFFFFFL;
    public static final long SIGNED_MIN_LEN6_VAL = -140737488355328L;
    public static final long SIGNED_MAX_LEN6_VAL = 0x7FFFFFFFFFFFL;
    public static final long SIGNED_MIN_LEN7_VAL = -36028797018963968L;
    public static final long SIGNED_MAX_LEN7_VAL = 0x7FFFFFFFFFFFFFL;
    public static final long SIGNED_MIN_LEN8_VAL = Long.MIN_VALUE;
    public static final long SIGNED_MAX_LEN8_VAL = Long.MAX_VALUE;
    public static final long UNSIGNED_MAX_LEN1_VAL = 255L;
    public static final long UNSIGNED_MAX_LEN2_VAL = 65535L;
    public static final long UNSIGNED_MAX_LEN3_VAL = 0xFFFFFFL;
    public static final long UNSIGNED_MAX_LEN4_VAL = 0xFFFFFFFFL;
    public static final long UNSIGNED_MAX_LEN5_VAL = 0xFFFFFFFFFFL;
    public static final long UNSIGNED_MAX_LEN6_VAL = 0xFFFFFFFFFFFFL;
    public static final long UNSIGNED_MAX_LEN7_VAL = 0xFFFFFFFFFFFFFFL;
    public static final long UNSIGNED_MAX_LEN8_VAL = Long.MAX_VALUE;
    private int offset;
    private int length;
    private boolean signed;
    private long signExtension;
    private long maxValue;
    private long minValue;

    public BinaryAsLongField(int offset) {
        this(offset, 8, true);
    }

    public BinaryAsLongField(int offset, int length) {
        this(offset, length, true);
    }

    public BinaryAsLongField(int offset, int length, boolean signed) {
        this.offset = offset;
        this.length = length;
        this.signed = signed;
        switch (length) {
            case 1: {
                if (signed) {
                    this.signExtension = -256L;
                    this.maxValue = 127L;
                    this.minValue = -128L;
                    break;
                }
                this.maxValue = 255L;
                this.minValue = 0L;
                break;
            }
            case 2: {
                if (signed) {
                    this.signExtension = -65536L;
                    this.maxValue = 32767L;
                    this.minValue = -32768L;
                    break;
                }
                this.maxValue = 65535L;
                this.minValue = 0L;
                break;
            }
            case 3: {
                if (signed) {
                    this.signExtension = -16777216L;
                    this.maxValue = 0x7FFFFFL;
                    this.minValue = -8388608L;
                    break;
                }
                this.maxValue = 0xFFFFFFL;
                this.minValue = 0L;
                break;
            }
            case 4: {
                if (signed) {
                    this.signExtension = -4294967296L;
                    this.maxValue = Integer.MAX_VALUE;
                    this.minValue = Integer.MIN_VALUE;
                    break;
                }
                this.maxValue = 0xFFFFFFFFL;
                this.minValue = 0L;
                break;
            }
            case 5: {
                if (signed) {
                    this.signExtension = -1099511627776L;
                    this.maxValue = 0x7FFFFFFFFFL;
                    this.minValue = -549755813888L;
                    break;
                }
                this.maxValue = 0xFFFFFFFFFFL;
                this.minValue = 0L;
                break;
            }
            case 6: {
                if (signed) {
                    this.signExtension = -281474976710656L;
                    this.maxValue = 0x7FFFFFFFFFFFL;
                    this.minValue = -140737488355328L;
                    break;
                }
                this.maxValue = 0xFFFFFFFFFFFFL;
                this.minValue = 0L;
                break;
            }
            case 7: {
                if (signed) {
                    this.signExtension = -72057594037927936L;
                    this.maxValue = 0x7FFFFFFFFFFFFFL;
                    this.minValue = -36028797018963968L;
                    break;
                }
                this.maxValue = 0xFFFFFFFFFFFFFFL;
                this.minValue = 0L;
                break;
            }
            case 8: {
                if (signed) {
                    this.signExtension = 0L;
                    this.maxValue = Long.MAX_VALUE;
                    this.minValue = Long.MIN_VALUE;
                    break;
                }
                this.maxValue = Long.MAX_VALUE;
                this.minValue = 0L;
                break;
            }
            default: {
                throw new IllegalArgumentException("length must be between 1 and 8 bytes");
            }
        }
    }

    public int getByteLength() {
        return this.length;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public long getLong(byte[] buffer, int bufOffset) {
        int first = bufOffset + this.offset;
        int last = first + this.length - 1;
        long answer = 0L;
        for (int i = first; i <= last; ++i) {
            answer <<= 8;
            answer += (long)(buffer[i] & 0xFF);
        }
        if (this.signed) {
            if (buffer[first] < 0) {
                answer += this.signExtension;
            }
        } else if (answer < 0L) {
            throw new IllegalArgumentException("negative value in unsigned field");
        }
        return answer;
    }

    public long getLong(byte[] buffer) {
        return this.getLong(buffer, 0);
    }

    public void putLong(long value, byte[] buffer, int bufOffset) throws IllegalArgumentException {
        int last;
        if (value < this.minValue || value > this.maxValue) {
            throw new IllegalArgumentException("" + value);
        }
        int first = bufOffset + this.offset;
        for (int i = last = first + this.length - 1; i >= first; --i) {
            buffer[i] = (byte)value;
            value >>= 8;
        }
    }

    public void putLong(long value, byte[] buffer) throws IllegalArgumentException {
        this.putLong(value, buffer, 0);
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public boolean equals(Long aLong, long along) {
        if (aLong == null) {
            return false;
        }
        return aLong == along;
    }
}

